/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.io.IOException;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;

final class MoveFile
extends AtomicTask {
    private final File _originalFile;
    private final File _newFile;

    MoveFile(File originalFile, File newFile) {
        this._originalFile = originalFile;
        this._newFile = newFile;
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        if (!this._newFile.getParentFile().exists()) {
            this._newFile.getParentFile().mkdirs();
        }
        File canonNewFile = null;
        try {
            canonNewFile = this._newFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (canonNewFile == null) {
            canonNewFile = this._newFile;
        }
        if (!this._originalFile.renameTo(canonNewFile)) {
            throw new TaskFailedException(UpdateArb.format("RENAME_FAILED", this._originalFile.getPath(), this._newFile.getPath()));
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (!this._newFile.renameTo(this._originalFile)) {
            throw new TaskFailedException(UpdateArb.format("RENAME_FAILED", this._newFile.getPath(), this._originalFile.getPath()));
        }
    }
}

