/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.boot.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class IdeMacros {
    private static final Map<Path, Map<String, String>> CACHE = new HashMap<Path, Map<String, String>>();

    private IdeMacros() {
    }

    public static synchronized Map<String, String> loadMacroFile(Path path) throws IOException {
        Map<String, String> macros = CACHE.get(path);
        if (macros != null) {
            return macros;
        }
        macros = new HashMap<String, String>();
        CACHE.put(path, macros);
        try (InputStream bytes = Files.newInputStream(path, new OpenOption[0]);){
            Properties properties = new Properties();
            if (path.getFileName().endsWith(".xml")) {
                properties.loadFromXML(bytes);
            } else {
                properties.load(bytes);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                StringBuilder builder = new StringBuilder();
                int start = 0;
                while (start < value.length()) {
                    int end = value.indexOf(44, start);
                    if (end < 0) {
                        end = value.length();
                    }
                    if (value.regionMatches(start, "file:", 0, "file:".length())) {
                        Path resolution = path.getParent().resolve(value.substring(start + "file:".length(), end).trim()).normalize();
                        builder.append(resolution);
                    } else {
                        builder.append(value, start, end);
                    }
                    if (end < value.length()) {
                        builder.append(',');
                    }
                    start = end + 1;
                }
                macros.put(key, builder.toString());
            }
        }
        return macros;
    }
}

