/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public abstract class URLClassLocator
extends BaseClassLocator {
    protected boolean _hasNonDefaultSuffixes;
    protected boolean _checkForDefaultSuffix;
    protected Set<String> _suffixes;
    protected URL _rootURL;
    protected int _fileType;
    public static final int CLASS_TYPE = 1;
    public static final int SOURCE_TYPE = 2;
    @CodeSharingSafe(value="StaticField")
    public static final String[] CLASS_SUFFIXES = new String[]{".class"};
    @CodeSharingSafe(value="StaticField")
    public static final String[] SOURCE_SUFFIXES = new String[]{".java", ".sqlj", ".groovy"};

    private void initSuffixes(String[] suffixes) {
        this._suffixes = new LinkedHashSet<String>(suffixes.length);
        for (int x = 0; x < suffixes.length; ++x) {
            this._suffixes.add(suffixes[x]);
        }
    }

    public URLClassLocator(URL rootURL, int fileType) {
        this._rootURL = URLFactory.intern((URL)rootURL);
        this._fileType = fileType;
        if (this.isSourceTypeLocator()) {
            this.initSuffixes(SOURCE_SUFFIXES);
        } else {
            this.initSuffixes(CLASS_SUFFIXES);
        }
        this._checkForDefaultSuffix = this._suffixes.size() > 1;
    }

    protected URL getRootURL() {
        return this._rootURL;
    }

    protected int getFileType() {
        return this._fileType;
    }

    protected boolean isSourceTypeLocator() {
        return this._fileType == 2;
    }

    protected boolean isClassTypeLocator() {
        return this._fileType == 1;
    }

    protected boolean isMatchingFileType(URL url) {
        String filename = url.getFile();
        return this.isMatchingFileType(filename);
    }

    protected boolean isMatchingFileType(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex <= 0) {
            return false;
        }
        return this._suffixes.contains(filename.substring(dotIndex));
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        if (this.isSourceTypeLocator()) {
            return this.getURL(fqClassName);
        }
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        if (this.isClassTypeLocator()) {
            return this.getURL(fqClassName);
        }
        return null;
    }

    @Override
    protected Object getClasspathTreeNode() {
        return this._rootURL;
    }

    @Override
    public void setContainsModuleClasses(boolean containsModuleClasses) {
        if (this._fileType == 1) {
            super.setContainsModuleClasses(containsModuleClasses);
        }
    }
}

