/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.migration.parser.DefaultParserFactory;
import oracle.dbtools.migration.parser.IParserFactory;
import oracle.dbtools.migration.parser.ITranslatorDescriptor;
import oracle.dbtools.migration.parser.TranslatorHook;
import oracle.dbtools.migration.translation.api.ITranslator;

public class ParserFactorySQLDev
extends DefaultParserFactory
implements IParserFactory {
    private boolean hookProcessed = false;
    private static Map<String, ITranslatorDescriptor> s_loadedTranslators = new HashMap<String, ITranslatorDescriptor>();

    private ITranslator newParser(String string) {
        if (!this.hookProcessed) {
            TranslatorHook.getInstance();
            this.hookProcessed = true;
        }
        ITranslator iTranslator = null;
        try {
            if (s_loadedTranslators.containsKey(string)) {
                ITranslatorDescriptor iTranslatorDescriptor = s_loadedTranslators.get(string);
                iTranslator = iTranslatorDescriptor.getTranslator();
            }
        }
        catch (Exception exception) {
            this.LOGGER.log(Level.SEVERE, MessageFormat.format("Failed to get Translator for {0}", string));
            iTranslator = null;
        }
        return iTranslator;
    }

    public ITranslator getParser(String string) {
        return this.newParser(string);
    }

    public void registerTranslator(ITranslatorDescriptor iTranslatorDescriptor) {
        s_loadedTranslators.put(iTranslatorDescriptor.getClazz(), iTranslatorDescriptor);
    }

    public boolean containsParser(String string) {
        return s_loadedTranslators.containsKey(string);
    }
}

