/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui.babelfish;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import oracle.aurora.server.tools.loadjava.LoadJavaMain;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.babelfish.ABablefishInstallTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;

public class OnlineBabelfishInstallTask
extends ABablefishInstallTask {
    String _profileSQL = null;
    String _profileConn = null;
    String _packageFileName = null;
    String _packageName = null;

    public OnlineBabelfishInstallTask(DBObject dBObject, String string, String string2, String string3, String string4) {
        super("Online SQL Translator Install", true, IRaptorTaskRunMode.MODAL_OPTIONAL);
        this._node = dBObject;
        this._userName = string;
        this._profileConn = string3;
        this._profileSQL = string2;
        this._translatorType = string4;
        this._packageFileName = OnlineBabelfishInstallTask.getPackageFileName(this._translatorType);
        this._packageName = OnlineBabelfishInstallTask.getPackageName(this._translatorType);
    }

    protected Void doWork() throws TaskException {
        block14: {
            boolean bl = false;
            Connection connection = null;
            try {
                Object object;
                Object object2;
                try {
                    connection = this._node.getConnection();
                    object2 = this.checkPackage(connection, this._userName, this._packageName);
                    if (object2 != null) {
                        throw new Exception((String)object2);
                    }
                    object = this._node.getURL();
                    bl = this.loadJava(connection, this._userName);
                }
                catch (Exception exception) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)exception);
                    throw exception;
                }
                if (bl) {
                    object2 = null;
                    if (this._translatorType.equalsIgnoreCase("Sybase SQL Translator")) {
                        object2 = OnlineBabelfishInstallTask.class.getResource("offline/package_sybase.sql");
                    } else if (this._translatorType.equalsIgnoreCase("SQL Server SQL Translator")) {
                        object2 = OnlineBabelfishInstallTask.class.getResource("offline/package_sqlserver.sql");
                    } else if (this._translatorType.equalsIgnoreCase("DB2 SQL Fingerprinter")) {
                        object2 = OnlineBabelfishInstallTask.class.getResource("offline/package_db2.sql");
                    }
                    object = new ByteArrayOutputStream();
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new ByteArrayOutputStream());
                    ScriptExecutor scriptExecutor = new ScriptExecutor((URL)object2, connection);
                    scriptExecutor.setScriptRunnerContext(new ScriptRunnerContext());
                    scriptExecutor.setOut(bufferedOutputStream);
                    scriptExecutor.run();
                    if (this._profileConn != null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream);
                        ScriptExecutor scriptExecutor2 = new ScriptExecutor("set echo on\ngrant execute on " + this._packageName + " to " + this.getSchemaName(this._profileConn), connection);
                        scriptExecutor2.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptExecutor2.getScriptRunnerContext().setSqlError(4);
                        WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream2, null);
                        wrapListenBufferOutputStream.setRemoveForcePrint(true);
                        scriptExecutor2.getScriptRunnerContext().setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
                        scriptExecutor2.run();
                        if (scriptExecutor2.getScriptRunnerContext().getExited()) {
                            throw new Exception(SEMessages.getString("ScriptFailed") + "\n" + byteArrayOutputStream.toString("UTF-8"));
                        }
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        BufferedOutputStream bufferedOutputStream3 = new BufferedOutputStream(byteArrayOutputStream);
                        ScriptExecutor scriptExecutor3 = new ScriptExecutor("set echo on\n" + this._profileSQL, this.getConnection(this._profileConn));
                        scriptExecutor3.setScriptRunnerContext(new ScriptRunnerContext());
                        scriptExecutor3.getScriptRunnerContext().setSqlError(4);
                        WrapListenBufferOutputStream wrapListenBufferOutputStream2 = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream3, null);
                        wrapListenBufferOutputStream2.setRemoveForcePrint(true);
                        scriptExecutor3.getScriptRunnerContext().setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream2);
                        scriptExecutor3.run();
                        if (scriptExecutor3.getScriptRunnerContext().getExited()) {
                            throw new Exception(SEMessages.getString("ScriptFailed") + "\n" + byteArrayOutputStream.toString("UTF-8"));
                        }
                    }
                    break block14;
                }
                throw new Exception("LoadJava Failed");
            }
            catch (Exception exception) {
                throw new TaskException((Throwable)exception);
            }
        }
        return null;
    }

    private boolean loadJava(Connection connection, String string) {
        try {
            String[] stringArray = this.getLoadJavaArguments(connection, string);
            String[] stringArray2 = OnlineBabelfishInstallTask.getJarFiles(this._translatorType);
            int n = 1;
            for (String string2 : stringArray2) {
                this.checkCanProceed();
                File file = new File(string2);
                this.getRaptorTaskProgressUpdater().getDescriptor().setMessage("Loading file:" + string2);
                stringArray[10] = file.getAbsolutePath();
                stringArray[6] = OnlineBabelfishInstallTask.getInstallHome() + OnlineBabelfishInstallTask.createMissingFileName(this.getFileName(file.getName()));
                ++n;
                LoadJavaMain.main((String[])stringArray);
            }
        }
        catch (ExecutionException executionException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected String[] getLoadJavaArguments(Connection connection, String string) {
        try {
            String string2 = connection.getMetaData().getURL();
            String string3 = Connections.getInstance().getConnectionName(connection);
            Properties properties = Connections.getInstance().getConnectionInfo(string3);
            String string4 = properties.getProperty("password");
            if (string4 == null) {
                string4 = this.getPassword(SEMessages.format("PasswordRequest", string), true);
            }
            if (string4 != null) {
                String string5 = string + "/" + string4 + "@" + string2.substring(18);
                String[] stringArray = new String[]{"-user", string5, "-thin", "-force", "-definer", "-genmissingjar", "genmissing_", "-verbose", "-resolver", "((* " + string + ")(* PUBLIC)(* -))", "filename"};
                return stringArray;
            }
            return null;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }
}

