/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import oracle.dbtools.migration.gui.GlassPaneTextDisplay;
import oracle.dbtools.migration.gui.ParserSetting;
import oracle.dbtools.migration.gui.SEMessages;
import oracle.dbtools.migration.gui.SQLObjSourceWorksheet;
import oracle.dbtools.migration.gui.SQLObjTargetWorksheet;
import oracle.dbtools.migration.gui.ScratchEditorProvider;
import oracle.dbtools.worksheet.ActionProvider;

public class SQLObjDoubleWorksheetGUI
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    SQLObjSourceWorksheet m_sourceWS = null;
    SQLObjTargetWorksheet m_targetWS = null;
    private boolean m_isSourceSelected = true;
    private boolean m_isFirstPaint = true;
    protected ArrayList<ActionProvider> m_providers = new ArrayList();

    public boolean isSourceSelected() {
        return this.m_isSourceSelected;
    }

    public SQLObjDoubleWorksheetGUI() {
        super(1);
        this.setOneTouchExpandable(true);
        ScratchEditorProvider scratchEditorProvider = new ScratchEditorProvider();
        this.m_providers.add(scratchEditorProvider);
        ParserSetting parserSetting = new ParserSetting();
        this.m_sourceWS = new SQLObjSourceWorksheet(this.m_providers, parserSetting);
        this.m_targetWS = new SQLObjTargetWorksheet(parserSetting);
        scratchEditorProvider.setWorksheets(this.m_sourceWS, this.m_targetWS);
        Component component = this.m_sourceWS.getGUI();
        Component component2 = this.m_targetWS.getGUI();
        component.setMinimumSize(new Dimension(1, 1));
        component2.setMinimumSize(new Dimension(1, 1));
        JRootPane jRootPane = new JRootPane();
        jRootPane.setGlassPane(new GlassPaneTextDisplay(SEMessages.getString("SourceNA")));
        jRootPane.setContentPane((Container)component);
        this.setLeftComponent(jRootPane);
        JRootPane jRootPane2 = new JRootPane();
        jRootPane2.setGlassPane(new GlassPaneTextDisplay(SEMessages.getString("TargetNA")));
        jRootPane2.setContentPane((Container)component2);
        this.setRightComponent(jRootPane2);
    }

    public void activate() {
        this.initFocusListners();
        this.m_targetWS.getFocusedEditorPane().requestFocusInWindow();
        this.m_sourceWS.getFocusedEditorPane().requestFocusInWindow();
        this.m_sourceWS.activate();
        this.m_targetWS.activate();
    }

    private void initFocusListners() {
        this.m_sourceWS.getDefaultFocusComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SQLObjDoubleWorksheetGUI.this.m_isSourceSelected = true;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.m_targetWS.getDefaultFocusComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SQLObjDoubleWorksheetGUI.this.m_isSourceSelected = false;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.getSourceWS().getPersistedObject() == null) {
            if (this.m_isFirstPaint) {
                this.getLeftComponent().setMinimumSize(new Dimension());
                this.setDividerLocation(1.0);
                this.getRightComponent().setMinimumSize(new Dimension());
                this.setDividerLocation(0.0);
                this.m_isFirstPaint = false;
            }
        } else if (this.m_isFirstPaint) {
            this.setDividerLocation(0.5);
            this.m_isFirstPaint = false;
        }
        super.paint(graphics);
    }

    public boolean getInitialPaint() {
        return this.m_isFirstPaint;
    }

    public void setInitialPaint(boolean bl) {
        this.m_isFirstPaint = bl;
    }

    public SQLObjSourceWorksheet getSourceWS() {
        return this.m_sourceWS;
    }

    public void setSourceWS(SQLObjSourceWorksheet sQLObjSourceWorksheet) {
        this.m_sourceWS = sQLObjSourceWorksheet;
    }

    public SQLObjTargetWorksheet getTargetWS() {
        return this.m_targetWS;
    }

    public void setTargetWS(SQLObjTargetWorksheet sQLObjTargetWorksheet) {
        this.m_targetWS = sQLObjTargetWorksheet;
    }
}

