/*
 * Decompiled with CFR 0.152.
 */
package ice.xslt;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DNode;
import ice.util.ICEException;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Node;

public class XalanTransformer
implements ice.pilots.html4.Transformer {
    protected XalanTransformer() {
    }

    public boolean transform(Node src, Node template, Node result) throws IOException {
        this.doTransform(src, template, result);
        return true;
    }

    public boolean transform(Node src, Node template, Writer writer) throws IOException {
        DNode dsrc = (DNode)src;
        DDocument parent = dsrc.getOwnerDDocument();
        DDocument doc = parent.getDom().createDDocument(parent.getPilot(), false);
        this.doTransform(src, template, doc);
        this.doSerialize(doc, writer);
        return true;
    }

    private void doTransform(final Node src, final Node template, final Node destination) throws IOException {
        BoxedCode boxed = new BoxedCode(){

            public Object run() {
                try {
                    XalanTransformer.this.doTransformImpl(src, template, destination);
                    return null;
                }
                catch (TransformerException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                    throw new ProxyException(ex);
                }
            }
        };
        try {
            SecurityKit.doPrivileged(boxed);
        }
        catch (ProxyException ex) {
            throw new ICEException(1, 4, 17);
        }
    }

    void doTransformImpl(Node src, Node template, Node destination) throws TransformerException {
        TransformerFactory f = TransformerFactory.newInstance();
        Transformer transformer = f.newTransformer(new DOMSource(template));
        DOMSource domSource = new DOMSource(src);
        DOMResult domDestination = new DOMResult(destination);
        transformer.transform(domSource, domDestination);
    }

    private void doSerialize(final Node node, final Writer writer) throws IOException {
        BoxedCode boxed = new BoxedCode(){

            public Object run() {
                try {
                    XalanTransformer.this.doSerializeImpl(node, writer);
                    return null;
                }
                catch (IOException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                    throw new ProxyException(ex);
                }
            }
        };
        try {
            SecurityKit.doPrivileged(boxed);
        }
        catch (ProxyException ex) {
            throw (IOException)ex.getTarget();
        }
    }

    void doSerializeImpl(Node node, Writer writer) throws IOException {
        Serializer serializer = null;
        Properties props = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
        serializer = SerializerFactory.getSerializer((Properties)props);
        serializer.setWriter(writer);
        serializer.asDOMSerializer().serialize(node);
        serializer.reset();
    }
}

