/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.debug.Debug;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;

public class Defs {
    public static final Object NOT_FOUND = new Object();
    public static final Object NO_SYNCHRONIZATION = null;
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static Properties sandBoxedProperties = new Properties();
    private static boolean isSandBoxed = false;

    public static Object[] newObjectArray(int size) {
        return size != 0 ? new Object[size] : EMPTY_OBJECT_ARRAY;
    }

    public static String property(String name) {
        return Defs.property(name, null);
    }

    public static String property(String name, String defaultValue) {
        try {
            if (!isSandBoxed) {
                return System.getProperty(name, defaultValue);
            }
            return sandBoxedProperties.getProperty(name, defaultValue);
        }
        catch (SecurityException ex) {
            isSandBoxed = true;
            Defs.property(name, defaultValue);
            return defaultValue;
        }
    }

    public static Object objectProperty(String name) {
        try {
            if (!isSandBoxed) {
                Properties props = System.getProperties();
                return props.get(name);
            }
            return sandBoxedProperties.get(name);
        }
        catch (SecurityException ex) {
            isSandBoxed = true;
            return sandBoxedProperties.get(name);
        }
    }

    public static int intProperty(String name, int defaultValue) {
        String value = Defs.property(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                Defs.debug(ex, "Failed to parse property");
            }
        }
        return defaultValue;
    }

    public static boolean booleanProperty(String name) {
        return Defs.booleanProperty(name, false);
    }

    public static boolean booleanProperty(String name, boolean defaultValue) {
        String value = Defs.property(name);
        if (value != null) {
            switch (value.length()) {
                case 2: {
                    if (!"no".equals(value.toLowerCase())) break;
                    return false;
                }
                case 3: {
                    if (!"yes".equals(value.toLowerCase())) break;
                    return true;
                }
                case 4: {
                    if (!"true".equals(value.toLowerCase())) break;
                    return true;
                }
                case 5: {
                    if (!"false".equals(value.toLowerCase())) break;
                    return false;
                }
            }
        }
        return defaultValue;
    }

    public static String sysProperty(String name) {
        return Defs.property(name);
    }

    public static String sysProperty(String name, String defaultValue) {
        return Defs.property(name, defaultValue);
    }

    public static int sysPropertyInt(String name, int defaultValue) {
        return Defs.intProperty(name, defaultValue);
    }

    public static boolean sysPropertyBoolean(String name) {
        return Defs.booleanProperty(name);
    }

    public static boolean sysPropertyBoolean(String name, boolean defaultValue) {
        return Defs.booleanProperty(name, defaultValue);
    }

    public static void setProperty(String property, Object value) {
        try {
            if (!isSandBoxed) {
                Properties prop = System.getProperties();
                if (value != null) {
                    prop.put(property, value);
                    sandBoxedProperties.put(property, value);
                }
            } else if (value != null) {
                sandBoxedProperties.put(property, value);
            }
        }
        catch (SecurityException ex) {
            isSandBoxed = true;
            Defs.setProperty(property, value);
        }
    }

    public static void setProperty(String property, String value) {
        Defs.setProperty(property, (Object)value);
    }

    public static void setSandBoxEnabled() {
        isSandBoxed = true;
    }

    public static void setSystemProperty(String name, String value) {
        Defs.setProperty(name, value);
    }

    public static Class getClass(String className) {
        Exception exception;
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            exception = ex;
        }
        catch (SecurityException c) {
            exception = c;
        }
        Defs.debug(exception, "Failed to get class");
        return null;
    }

    public static Object newClassInstance(Class cl) {
        Throwable throwable;
        try {
            return cl.newInstance();
        }
        catch (IllegalAccessException ex) {
            throwable = ex;
        }
        catch (InstantiationException ex) {
            throwable = ex;
        }
        catch (LinkageError ex) {
            throwable = ex;
        }
        catch (SecurityException ex) {
            throwable = ex;
        }
        Defs.debug(throwable, "Failed to get instance of class");
        return null;
    }

    public static Object newClassInstance(String className) {
        Class cl = Defs.getClass(className);
        return cl == null ? null : Defs.newClassInstance(cl);
    }

    public static Method getMethod(Class sourceClass, String name, Class[] signature) {
        Exception exception;
        try {
            return sourceClass.getMethod(name, signature);
        }
        catch (NoSuchMethodException ex) {
            exception = ex;
        }
        catch (SecurityException c) {
            exception = c;
        }
        Defs.debug(exception, "Failed to get method");
        return null;
    }

    public static Method getMethod(String className, String name, Class[] signature) {
        Class c = Defs.getClass(className);
        if (c != null) {
            return Defs.getMethod(c, name, signature);
        }
        return null;
    }

    public static void badArg() throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    private static void debug(Throwable ex, String message) {
        Debug.trace(message + ": " + ex.getMessage());
    }

    static {
        try {
            Properties sysProperties = System.getProperties();
            Enumeration<Object> keys = sysProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Object value = sysProperties.get(key);
                if (value == null) continue;
                Defs.setProperty(key, value);
            }
        }
        catch (SecurityException e) {
            isSandBoxed = true;
        }
        try {
            if (isSandBoxed) {
                sandBoxedProperties.put("java.version", System.getProperty("java.version"));
                sandBoxedProperties.put("java.vm.version", System.getProperty("java.vm.version"));
                sandBoxedProperties.put("java.vm.vendor", System.getProperty("java.vm.vendor"));
                sandBoxedProperties.put("path.separator", System.getProperty("path.separator"));
                sandBoxedProperties.put("java.vm.name", System.getProperty("java.vm.name"));
                sandBoxedProperties.put("java.vm.specification.name", System.getProperty("java.vm.specification.name"));
                sandBoxedProperties.put("line.separator", System.getProperty("line.separator"));
                sandBoxedProperties.put("os.name", System.getProperty("os.name"));
                sandBoxedProperties.put("java.specification.name", System.getProperty("java.specification.name"));
                sandBoxedProperties.put("java.class.version", System.getProperty("java.class.version"));
                sandBoxedProperties.put("os.version", System.getProperty("os.version"));
                sandBoxedProperties.put("file.separator", System.getProperty("file.separator"));
            }
        }
        catch (SecurityException e) {
            Defs.debug(e, "Failed to copy sand boxed properties");
        }
    }
}

