/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ImageConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class ImageInputStream
extends InputStream {
    private ImageConnection ic;
    private URL realUrlObj;
    private InputStream realIn;
    private URLConnection realUC;

    ImageInputStream(ImageConnection ic, URL realUrlObj) {
        this.ic = ic;
        this.realUrlObj = realUrlObj;
    }

    private void checkRealIn() throws IOException {
        if (this.realIn == null && this.realUrlObj != null) {
            if (this.ic.isStopRequested()) {
                return;
            }
            this.realUC = this.realUrlObj.openConnection();
            this.realIn = this.realUC.getInputStream();
        }
    }

    private void closeRealIn() throws IOException {
        if (this.realIn != null) {
            this.realIn.close();
            this.realIn = null;
        }
        this.realUC = null;
    }

    String getContentType() {
        try {
            this.checkRealIn();
            if (this.realUC != null) {
                return this.realUC.getContentType();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void close() throws IOException {
        this.closeRealIn();
        this.ic.inputStreamDone();
    }

    public int read() throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.read();
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.read(b, off, len);
        }
        return -1;
    }

    public long skip(long n) throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1L;
        }
        if (this.realIn != null) {
            return this.realIn.skip(n);
        }
        return 0L;
    }

    public int available() throws IOException {
        this.checkRealIn();
        if (this.ic.isStopRequested()) {
            this.closeRealIn();
            return -1;
        }
        if (this.realIn != null) {
            return this.realIn.available();
        }
        return 0;
    }

    public boolean markSupported() {
        try {
            this.checkRealIn();
            if (this.realIn == null) {
                return false;
            }
            return this.realIn.markSupported();
        }
        catch (IOException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            return false;
        }
    }

    public void mark(int readlimit) {
        block3: {
            try {
                this.checkRealIn();
                if (this.realIn == null) {
                    return;
                }
                this.realIn.mark(readlimit);
            }
            catch (IOException ex) {
                if (!Debug.ex) break block3;
                Debug.ex(ex);
            }
        }
    }

    public void reset() throws IOException {
        this.checkRealIn();
        if (this.realIn == null) {
            return;
        }
        this.realIn.reset();
    }
}

