/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.debug.Debug;
import ice.mozilla.javascript.ScriptRuntime;
import ice.mozilla.javascript.Undefined;
import ice.mozilla.javascript.WrappedException;
import ice.mozilla.javascript.Wrapper;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;

final class EcmaEnv
extends DynEnv {
    private TheScripter scripter;

    EcmaEnv(TheScripter scripter_arg) {
        this.scripter = scripter_arg;
    }

    public Scripter getScripter() {
        return this.scripter;
    }

    public RuntimeException wrapException(Exception ex) {
        return WrappedException.wrapException(ex);
    }

    public Integer wrapInt(int value) {
        return new Integer(value);
    }

    public Object wrapLong(long value) {
        return new Double(value);
    }

    public Object wrapDouble(double value) {
        return new Double(value);
    }

    public Object wrapMethod(DynamicObject dynamic, String methodName) {
        return this.scripter.wrapDynamicMethod(dynamic, methodName);
    }

    public Object wrapDynamic(DynamicObject dynamic) {
        return this.scripter.wrapDynamicObject(dynamic);
    }

    public Object wrapGeneralObject(Object obj) {
        if (obj instanceof DynamicObject) {
            Debug.bug();
        }
        if (obj instanceof String) {
            Debug.bug();
        }
        return obj;
    }

    public Object wrapVoid() {
        return null;
    }

    public Object wrapEventHandler(DynamicObject target, Object handler) {
        return this.scripter.wrapEventHandler(target, handler);
    }

    public boolean toBoolean(Object obj) {
        return ScriptRuntime.toBoolean(obj);
    }

    public double toDouble(Object obj) {
        return ScriptRuntime.toNumber(obj);
    }

    public int toInt(Object obj) {
        long value = this.toPossibleInt(obj);
        if (value >= 0L) {
            return (int)value;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", ScriptRuntime.toString(obj), "int");
    }

    public long toPossibleInt(Object obj) {
        int ivalue;
        double value;
        if (obj != null && (value = this.toDouble(obj)) == value && !Double.isInfinite(value) && (double)(ivalue = (int)(value = value > 0.0 ? Math.floor(value) : Math.ceil(value))) == value) {
            return 0xFFFFFFFFL & (long)ivalue;
        }
        return -1L;
    }

    public int checkBound(int value, int min_bound, int max_bound) {
        if (min_bound <= value && value <= max_bound) {
            return value;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", Integer.toString(value), "int in [" + min_bound + "," + max_bound + "]");
    }

    public long toLong(Object obj) {
        long lvalue;
        double value = this.toDouble(obj);
        if (value == value && !Double.isInfinite(value) && (double)(lvalue = (long)(value = value > 0.0 ? Math.floor(value) : Math.ceil(value))) == value) {
            return lvalue;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", ScriptRuntime.toString(obj), "long");
    }

    public String toStr(Object obj) {
        if (obj == null || obj == Undefined.instance) {
            return null;
        }
        return ScriptRuntime.toString(obj);
    }

    public Object toNative(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        return obj;
    }

    public boolean toBoolean(Object[] args, int index) {
        return index < args.length ? this.toBoolean(args[index]) : false;
    }

    public double toDouble(Object[] args, int index) {
        return index < args.length ? this.toDouble(args[index]) : Double.NaN;
    }

    public int toInt(Object[] args, int index) {
        return index < args.length ? this.toInt(args[index]) : 0;
    }

    public long toLong(Object[] args, int index) {
        return index < args.length ? this.toLong(args[index]) : 0L;
    }

    public String toStr(Object[] args, int index) {
        return index < args.length ? this.toStr(args[index]) : null;
    }

    public Object toNative(Object[] args, int index) {
        return index < args.length ? this.toNative(args[index]) : null;
    }

    public Object getRawObject(Object[] args, int index) {
        return index < args.length ? args[index] : Undefined.instance;
    }

    public int nativeIndexTest(Object object) {
        String name = ScriptRuntime.toString(object);
        double d = ScriptRuntime.toNumber(name);
        long index = ScriptRuntime.toUint32(d);
        if (index <= Integer.MAX_VALUE && (double)index == d && ScriptRuntime.numberToString(d, 10).equals(name)) {
            return (int)index;
        }
        return -1;
    }
}

