/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters;

import ice.debug.Debug;
import ice.scripters.WindowObj;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.util.Defs;
import java.net.MalformedURLException;
import java.net.URL;

public final class LocationObj
extends DynamicObject {
    private static final boolean use_base_as_location = Debug.extra && Defs.booleanProperty("ice.debug.use_base_as_location");
    final WindowObj window;
    private static final int Field_hash = 1;
    private static final int Field_host = 2;
    private static final int Field_href = 3;
    private static final int Field_hostname = 4;
    private static final int Field_pathname = 5;
    private static final int Field_port = 6;
    private static final int Field_protocol = 7;
    private static final int Field_search = 8;
    private static final int Method_replace = -1;
    private static final int Method_reload = -2;

    LocationObj(WindowObj itsWin) {
        this.window = itsWin;
    }

    private URL get_url() {
        if (use_base_as_location) {
            return this.window.theView.getBaseURL();
        }
        String loc = this.window.theView.getLocation();
        if (loc != null) {
            try {
                return new URL(loc);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getHash() {
        URL url = this.get_url();
        if (url == null) {
            return "";
        }
        String reference = url.getRef();
        return reference == null ? "" : "#" + reference;
    }

    private int getPort() {
        URL url = this.get_url();
        if (url == null) {
            return -1;
        }
        return url.getPort();
    }

    private String getHostname() {
        URL url = this.get_url();
        if (url == null) {
            return null;
        }
        String host = url.getHost();
        return host;
    }

    private String getHost() {
        URL url = this.get_url();
        if (url == null) {
            return null;
        }
        String host = url.getHost();
        int port = url.getPort();
        if (port > 0) {
            host = host + ":" + port;
        }
        return host;
    }

    String getHref() {
        URL url = this.get_url();
        if (url == null) {
            return "";
        }
        return url.toString();
    }

    private String getPathname() {
        int i;
        String pathname = null;
        URL url = this.get_url();
        if (url != null && (i = (pathname = url.getFile()).indexOf(63)) >= 0) {
            pathname = pathname.substring(0, i);
        }
        return pathname;
    }

    private String getProtocol() {
        String protocol = null;
        URL url = this.get_url();
        if (url != null) {
            protocol = url.getProtocol() + ':';
        }
        return protocol;
    }

    private String getSearch() {
        String searchPart = null;
        URL url = this.get_url();
        if (url != null) {
            String pathname = url.getFile();
            int i = pathname.indexOf(63);
            searchPart = i >= 0 ? pathname.substring(i) : "";
        }
        return searchPart;
    }

    private void setLocation(String location) {
        this.window.setLocation(location);
    }

    public void replace(String itsURL) {
        this.setLocation(itsURL);
    }

    public void reload() {
        this.window.setLocation(this.getHref());
    }

    public String toString() {
        return this.getHref();
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = LocationObj.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = LocationObj.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = LocationObj.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapStr(this.getHash());
            }
            case 2: {
                return env.wrapStr(this.getHost());
            }
            case 3: {
                return env.wrapStr(this.getHref());
            }
            case 4: {
                return env.wrapStr(this.getHostname());
            }
            case 5: {
                return env.wrapStr(this.getPathname());
            }
            case 6: {
                int port = this.getPort();
                if (port > 0) {
                    return env.wrapInt(port);
                }
                return "";
            }
            case 7: {
                return env.wrapStr(this.getProtocol());
            }
            case 8: {
                return env.wrapStr(this.getSearch());
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        if (key_id == 3 || key_id == 5) {
            this.setLocation(env.toStr(value));
            return 1;
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        if (key_id == -2) {
            this.reload();
        } else if (key_id == -1) {
            this.replace(env.toStr(args[0]));
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                char c = s.charAt(1);
                if (c == 'a') {
                    guess = "hash";
                    id = 1;
                    break;
                }
                if (c == 'o') {
                    c = s.charAt(0);
                    if (c == 'h') {
                        guess = "host";
                        id = 2;
                        break;
                    }
                    if (c != 'p') break;
                    guess = "port";
                    id = 6;
                    break;
                }
                if (c != 'r') break;
                guess = "href";
                id = 3;
                break;
            }
            case 6: {
                char c = s.charAt(0);
                if (c == 'r') {
                    guess = "reload";
                    id = -2;
                    break;
                }
                if (c != 's') break;
                guess = "search";
                id = 8;
                break;
            }
            case 7: {
                guess = "replace";
                id = -1;
                break;
            }
            case 8: {
                char c = s.charAt(1);
                if (c == 'a') {
                    guess = "pathname";
                    id = 5;
                    break;
                }
                if (c == 'o') {
                    guess = "hostname";
                    id = 4;
                    break;
                }
                if (c != 'r') break;
                guess = "protocol";
                id = 7;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

