/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;

public class TitledBorderPanel
extends Panel {
    public static int ETCHED_TYPE_LOWERED = 0;
    public static int ETCHED_TYPE_RAISED = 1;
    protected int etchedType = ETCHED_TYPE_LOWERED;
    private static int BASE_INSETS_TOP = 4;
    private static int BASE_INSETS_BOTTON = 8;
    private static int BASE_INSETS_LEFT = 8;
    private static int BASE_INSETS_RIGHT = 8;
    private Color shadowColor;
    private Color hightlightColor;
    public static int TITLE_LEADING = 8;
    protected String title;
    private FontMetrics fm;
    private int titleHeight = 2;
    private int titleWidth = 0;
    private int titleFontAscent = 1;
    private int insetsTop = BASE_INSETS_TOP;
    private int insetsBottom = BASE_INSETS_BOTTON;
    private int insetsLeft = BASE_INSETS_LEFT;
    private int insetsRight = BASE_INSETS_RIGHT;

    public TitledBorderPanel(String title) {
        this(title, ETCHED_TYPE_LOWERED);
    }

    public TitledBorderPanel(LayoutManager layout) {
        this(null, ETCHED_TYPE_LOWERED);
        this.setLayout(layout);
    }

    public TitledBorderPanel(String title, LayoutManager layout) {
        this(title, ETCHED_TYPE_LOWERED);
        this.setLayout(layout);
    }

    public TitledBorderPanel(int etched_type) {
        this(null, etched_type);
    }

    public TitledBorderPanel(String title, int etched_type) {
        this(title, etched_type, SystemColor.control);
    }

    public TitledBorderPanel(String title, int etched_type, Color bgColor) {
        this.title = title;
        this.etchedType = etched_type;
        this.setBackground(bgColor);
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.fm != null) {
            this.titleWidth = this.fm.stringWidth(title);
        }
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        if (this.title != null && this.title.length() > 0) {
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            this.titleHeight = this.fm.getHeight();
            this.titleWidth = this.fm.stringWidth(this.title);
            this.titleFontAscent = this.fm.getAscent();
            this.insetsTop = BASE_INSETS_TOP + this.titleHeight;
        }
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.hightlightColor = c.brighter();
        this.shadowColor = c.darker();
    }

    public Insets getInsets() {
        return new Insets(this.insetsTop, this.insetsLeft, this.insetsBottom, this.insetsRight);
    }

    public int getInsetsBottom() {
        return this.insetsBottom;
    }

    public void setInsetsBottom(int insetsBottom) {
        this.insetsBottom = insetsBottom + BASE_INSETS_BOTTON;
    }

    public int getInsetsLeft() {
        return this.insetsLeft;
    }

    public void setInsetsLeft(int insetsLeft) {
        this.insetsLeft = insetsLeft + BASE_INSETS_LEFT;
    }

    public int getInsetsRight() {
        return this.insetsRight;
    }

    public void setInsetsRight(int insetsRight) {
        this.insetsRight = insetsRight + BASE_INSETS_RIGHT;
    }

    public int getInsetsTop() {
        return this.insetsTop;
    }

    public void setInsetsTop(int insetsTop) {
        this.insetsTop = insetsTop + BASE_INSETS_TOP + this.titleHeight;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        int shiftY = this.titleHeight / 2;
        g.setColor(this.etchedType == ETCHED_TYPE_LOWERED ? this.shadowColor : this.hightlightColor);
        g.drawRect(0, shiftY, size.width - 2, size.height - 2 - shiftY);
        g.setColor(this.etchedType == ETCHED_TYPE_LOWERED ? this.hightlightColor : this.shadowColor);
        g.drawLine(1, size.height - 3, 1, 1 + shiftY);
        g.drawLine(1, 1 + shiftY, size.width - 3, 1 + shiftY);
        g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        g.drawLine(size.width - 1, size.height - 1, size.width - 1, shiftY);
        if (this.title != null && this.title.length() != 0) {
            g.setColor(this.getBackground());
            g.fillRect(TITLE_LEADING - 2, 0, this.titleWidth + 2, this.titleHeight);
            g.setColor(this.getForeground().darker());
            g.drawString(this.title, TITLE_LEADING, this.titleFontAscent);
        }
    }
}

