/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing.dnd;

import ice.debug.Debug;
import ice.pilots.html4.ICEDropClient;
import ice.pilots.html4.swing.dnd.StringTransferable;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Reader;

public class DropTargetAgent {
    private DropTargetListener dtListener;
    private final int acceptableActions = 1;
    private DataFlavor[] acceptableFlavors = new DataFlavor[]{DataFlavor.plainTextFlavor, DataFlavor.stringFlavor};
    private ICEDropClient listener;

    public DropTargetAgent(ICEDropClient listener, Component target) {
        if (listener == null) {
            throw new IllegalArgumentException("DropListener cannot be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Drop Component cannot be null");
        }
        this.listener = listener;
        this.dtListener = new DropTargetListener(){

            public void dragOver(DropTargetDragEvent dsde) {
                if (DropTargetAgent.this.isDragOk(dsde)) {
                    dsde.acceptDrag(1);
                }
            }

            public void drop(DropTargetDropEvent e) {
                DataFlavor[] flavors = DropTargetAgent.this.acceptableFlavors;
                DataFlavor chosenFlavor = null;
                for (int i = 0; i < flavors.length; ++i) {
                    if (!e.isDataFlavorSupported(flavors[i])) continue;
                    chosenFlavor = flavors[i];
                    break;
                }
                if (chosenFlavor == null) {
                    e.rejectDrop();
                    return;
                }
                int sa = e.getSourceActions();
                if ((sa & 1) == 0) {
                    e.rejectDrop();
                    return;
                }
                Transferable data = null;
                try {
                    e.acceptDrop(1);
                    data = e.getTransferable();
                    if (data == null) {
                        throw new NullPointerException();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    e.dropComplete(false);
                    return;
                }
                Reader r = null;
                StringBuffer str = null;
                if (data != null) {
                    try {
                        r = chosenFlavor.getReaderForText(data);
                    }
                    catch (Exception ex) {
                        e.dropComplete(false);
                        return;
                    }
                    if (r != null) {
                        str = new StringBuffer();
                        int in = -1;
                        try {
                            while ((in = r.read()) >= 0) {
                                if (in == 0) continue;
                                str.append((char)in);
                            }
                        }
                        catch (IOException ioe) {
                            e.dropComplete(false);
                            Debug.trace("Exception reading drop payload: " + ioe);
                            return;
                        }
                    }
                }
                if (str != null && str.length() != 0) {
                    DropTargetAgent.this.publishDropEvent(str.toString());
                }
            }

            public void dropActionChanged(DropTargetDragEvent dsde) {
            }

            public void dragEnter(DropTargetDragEvent dsde) {
            }

            public void dragExit(DropTargetEvent dsde) {
            }
        };
        DropTarget dt = new DropTarget(target, this.acceptableActions, this.dtListener, true);
    }

    private void publishDropEvent(String payload) {
        this.listener.packageDropped(payload);
    }

    private boolean isDragOk(DropTargetDragEvent e) {
        DataFlavor[] flavors = StringTransferable.flavors;
        DataFlavor chosen = null;
        for (int i = 0; i < flavors.length; ++i) {
            if (!e.isDataFlavorSupported(flavors[i])) continue;
            chosen = flavors[i];
            break;
        }
        if (chosen == null) {
            return false;
        }
        int sa = e.getSourceActions();
        return (sa & this.acceptableActions) != 0;
    }
}

