/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import ice.pilots.html4.swing.OptionListModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormSelectChoicePre14
extends JComboBox
implements DSelectElement.SelectPainter,
Movable,
EventListener {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private OptionListModel listModel;
    private Border _originalBorder = this.getBorder();
    private boolean drawWidgetBorder = true;
    private Font font;

    FormSelectChoicePre14(DocView docView, DElement e) {
        this.docView = docView;
        this.sel = (DSelectElement)e;
        this.copyOptionsToView();
        this.validateTree();
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing() || !this.drawWidgetBorder) {
            super.paintComponent(g);
        } else {
            String text = (String)this.getSelectedItem();
            try {
                int rightX;
                int middleY;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int height = fontMetrics.getDescent();
                Rectangle bounds = this.getBounds();
                g.setColor(UIManager.getColor("Button.background"));
                g.fillRect(0, 0, bounds.width, bounds.height);
                g.setColor(UIManager.getColor("TextField.background"));
                g.fillRect(0, 0, bounds.width - bounds.height, bounds.height);
                Color dkShadow = UIManager.getColor("ComboBox.buttonDarkShadow");
                g.setColor(dkShadow);
                g.drawRect(0, 0, bounds.width, bounds.height);
                Color fg = UIManager.getColor("ComboBox.foreground");
                g.setColor(fg);
                g.drawString(text, 3, (bounds.height + 2) / 2 + height);
                g.setColor(dkShadow);
                int yStart = Math.round((bounds.height + 2) / 4);
                int xStart = bounds.width - bounds.height + yStart;
                int middleX = xStart + yStart;
                if (middleX > bounds.width) {
                    middleX = bounds.width;
                }
                if ((middleY = yStart + yStart + yStart) > bounds.height) {
                    middleY = bounds.height;
                }
                if ((rightX = xStart + yStart + yStart) > bounds.width) {
                    rightX = bounds.width;
                }
                g.fillPolygon(new int[]{xStart, rightX, middleX}, new int[]{yStart, yStart, middleY}, 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void updateFont() {
        if (this.box != null) {
            String text = (String)this.getSelectedItem();
            CSSAttribs css = this.box.getCSSAttribs();
            this.font = css.getTestedFont(text);
            if (!this.font.equals(this.getFont())) {
                this.setFont(this.font);
            }
        }
    }

    private void copyOptionsToView() {
        this.listModel = new OptionListModel(this.sel);
        this.listModel.ignoreItemChange = true;
        this.setModel(this.listModel);
        this.checkAttributes();
        this.listModel.ignoreItemChange = false;
        this.updateSelection();
    }

    private void updateSelection() {
        this.listModel.ignoreItemChange = true;
        int index = this.sel.getSelectedIndex();
        if (index >= 0 && index < this.getItemCount()) {
            this.setSelectedIndex(index);
            this.repaint();
        }
        this.listModel.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.setEnabled(!this.sel.getDisabled());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement opt, DAttr attr) {
    }

    public void onOptionStructChange() {
        this.copyOptionsToView();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
        if (box != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void addNotify() {
        super.addNotify();
        this.setNextFocusableComponent(this.getParent());
    }

    public void draw(Graphics g) {
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        KeyEvent ke;
        int keyCode;
        FormSelectChoicePre14 action = null;
        if (e instanceof KeyEvent && ((keyCode = (ke = (KeyEvent)e).getKeyCode()) == 38 || keyCode == 40)) {
            action = this;
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            super.processEvent(e);
        }
    }

    public void handleEvent(Event event) {
        if (((DOMEvent)event).getTypeId() == 22) {
            return;
        }
        DOMUIEvent de = (DOMUIEvent)event;
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this.setBorder(null);
            this.drawWidgetBorder = false;
        } else {
            this.setBorder(this._originalBorder);
            this.drawWidgetBorder = true;
        }
    }

    public void setFontHints(CSSAttribs css) {
        this.updateFont();
    }

    public int getClientHeight() {
        return this.getHeight();
    }

    public int getClientWidth() {
        return this.getWidth();
    }
}

