/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.debug.Debug;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.FocusIndicator;
import ice.pilots.html4.swing.LaFConfig;
import ice.pilots.html4.swing.Movable;
import ice.util.Defs;
import ice.util.alg.HashArray;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

class FormInputRadio
extends JRadioButton
implements ObjectPainter,
Movable {
    private static final String FOCUSIND_ENABLED = "ice.pilots.html4.swing.rbFocusIndEnabled";
    private static final String CUSTOM_FOCUSIND = "ice.pilots.html4.swing.rbFocusIndConfig";
    private static final boolean focusIndEnabled = Defs.sysPropertyBoolean("ice.pilots.html4.swing.rbFocusIndEnabled", true);
    private static HashArray customLafConfigs = new HashArray(4);
    private static LaFConfig currLaFConfig;
    private CSSAttribs css;
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private Border _originalBorder = this.getBorder();
    private static final int SIZE_ADJUSTMENT = 4;
    private JRadioButton none;
    private ButtonGroup group;

    private static HashArray getLaFConfigs() {
        LaFConfig[] lfc = new LaFConfig[]{new LaFConfig(1, "1.6", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", 3, 3, -3, -3), new LaFConfig(1, "1.6", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.6", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 0, 0, 0, 0), new LaFConfig(1, "1.6", "apple.laf.AquaLookAndFeel", false), new LaFConfig(1, "1.6", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, 0, 0), new LaFConfig(1, "1.6", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.5", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", 1, 0, 0, -1), new LaFConfig(1, "1.5", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.5", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 2, 0, 3, 0), new LaFConfig(1, "1.5", "apple.laf.AquaLookAndFeel", false), new LaFConfig(1, "1.5", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, 0, 0), new LaFConfig(1, "1.5", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.4", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.4", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 2, 0, 3, 0), new LaFConfig(1, "1.4", "apple.laf.AquaLookAndFeel", false), new LaFConfig(1, "1.4.2", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, 0, 0), new LaFConfig(1, "1.4.2", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.4", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.3", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.3", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 2, 0, 3, 0), new LaFConfig(1, "1.3", "apple.laf.AquaLookAndFeel", false), new LaFConfig(1, "1.3", "com.apple.mrj.swing.MacLookAndFeel", false), new LaFConfig(1, "1.3", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.2", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.2", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 2, 0, 3, 0), new LaFConfig(1, "1.2", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.1", "javax.swing.plaf.metal.MetalLookAndFeel", 0, 0, -1, -1), new LaFConfig(1, "1.1", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", 2, 0, 3, 0), new LaFConfig(1, "1.1", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", 0, 0, -1, -1)};
        HashArray configs = new HashArray(lfc.length);
        for (int i = 0; i < lfc.length; ++i) {
            configs.put(lfc[i].getKey(), (Object)lfc[i]);
        }
        Object[] c = customLafConfigs.getValues();
        for (int i = 0; i < c.length; ++i) {
            Object o = c[i];
            if (o == null) continue;
            LaFConfig config = (LaFConfig)o;
            configs.put(config.getKey(), (Object)config);
        }
        return configs;
    }

    FormInputRadio(DocView docView, DElement e, JRadioButton none, ButtonGroup group) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.none = none;
        this.group = group;
        this.setSelected(this.element.getChecked());
        this.checkAttributes();
        this.setBorder(null);
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        if (group != null) {
            group.add(this);
        }
    }

    private void checkAttributes() {
        this.setEnabled(!this.element.getDisabled());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
        if (this.isSelected() != this.element.getChecked()) {
            if (this.isSelected() && this.none != null) {
                this.none.setSelected(true);
            } else {
                this.setSelected(this.element.getChecked());
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        e.consume();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
        if (this.group != null) {
            this.group.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        if (box != null) {
            this.css = box.getCSSAttribs();
        }
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width + 4;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public void draw(Graphics g) {
        Color c = this.css.getBackgroundColor();
        if (c != null) {
            g.setColor(c);
            g.fillRect(0, 0, this.getPrefWidth() - 4, this.getPrefHeight());
        }
    }

    public void paint(Graphics g) {
        if (this.hasFocus() && focusIndEnabled && FormInputRadio.currLaFConfig.enabled) {
            if (this.isFocusPainted()) {
                this.setFocusPainted(false);
            }
            super.paint(g);
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            int x = insets.left + FormInputRadio.currLaFConfig.xOffset;
            int y = insets.top + FormInputRadio.currLaFConfig.yOffset;
            int width = size.width - insets.right - 4 + FormInputRadio.currLaFConfig.widthOffset;
            int height = size.height - insets.bottom + FormInputRadio.currLaFConfig.heightOffset;
            FocusIndicator.drawFocusRect(g, x, y, width, height);
            return;
        }
        if (!this.isFocusPainted()) {
            this.setFocusPainted(true);
        }
        super.paint(g);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    public void setBorderVisible(boolean aDrawBorder) {
        if (!aDrawBorder) {
            this._originalBorder = this.getBorder();
            this.setBorder(null);
        } else {
            this.setBorder(this._originalBorder);
        }
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        return this.getHeight();
    }

    public int getClientWidth() {
        return this.getWidth();
    }

    static {
        if (focusIndEnabled) {
            String configArgs = Defs.sysProperty(CUSTOM_FOCUSIND);
            customLafConfigs = FocusIndicator.parseCustomConfigs(1, configArgs);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("lookAndFeel")) {
                        HashArray lafConfigs = FormInputRadio.getLaFConfigs();
                        currLaFConfig = FocusIndicator.findLaFConfig(lafConfigs, new LaFConfig(1, "DEFAULT", "DEFAULT", 0, 0, -1, -1));
                    }
                }
            });
            HashArray lafConfigs = FormInputRadio.getLaFConfigs();
            currLaFConfig = FocusIndicator.findLaFConfig(lafConfigs, new LaFConfig(1, "DEFAULT", "DEFAULT", 0, 0, -1, -1));
        } else if (Debug.trace) {
            Debug.trace("Radio Button focus indicators disabled via 'ice.pilots.html4.swing.rbFocusIndEnabled' system property.");
        }
    }
}

