/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class MultipartEncoder
extends InputStream {
    private static final int START = 0;
    private static final int WORKING = 1;
    private static final int DONE = 2;
    private static final int BUFFERSIZE = 8192;
    private boolean doneEncoding = false;
    private Vector names = new Vector();
    private Vector values = new Vector();
    private Vector files = new Vector();
    private static String boundary = "AaB03x";
    private byte[] singleByteHack = new byte[1];
    private byte[] theBuffer = new byte[8192];
    private int bytesRead = 0;
    private int bufferSize = 0;
    private int mode = 0;
    private int currentPair = 0;
    private InputStream pendingIOStream = null;

    MultipartEncoder() {
    }

    void appendData(String name, String value) {
        this.names.addElement(name);
        this.values.addElement(value);
    }

    void appendFile(String name, String value) {
        if (value.length() == 0) {
            return;
        }
        this.names.addElement(name);
        this.values.addElement(value);
        this.files.addElement(name);
    }

    public int read() throws IOException {
        if (this.read(this.singleByteHack) == -1) {
            return -1;
        }
        return this.singleByteHack[0];
    }

    public int read(byte[] data) throws IOException {
        if (this.bytesRead < this.bufferSize) {
            if (this.bufferSize - this.bytesRead > data.length) {
                System.arraycopy(this.theBuffer, this.bytesRead, data, 0, data.length);
                this.bytesRead += data.length;
                return data.length;
            }
            System.arraycopy(this.theBuffer, this.bytesRead, data, 0, this.bufferSize - this.bytesRead);
            int tmp = this.bufferSize - this.bytesRead;
            this.bufferSize = 0;
            this.bytesRead = 0;
            return tmp;
        }
        if (this.mode == 2) {
            return -1;
        }
        if (this.pendingIOStream != null) {
            int retval = this.pendingIOStream.read(data);
            if (retval != -1) {
                return retval;
            }
            this.pendingIOStream = null;
            byte[] tmp = null;
            tmp = this.names.size() != 0 ? ("\r\n--" + boundary + "\r\n").getBytes() : ("\r\n--" + boundary + "--\r\n").getBytes();
            System.arraycopy(tmp, 0, this.theBuffer, 0, tmp.length);
            this.bufferSize = tmp.length;
            return this.read(data);
        }
        if (this.mode == 0) {
            StringBuffer b = this.encodeHeader();
            byte[] tmp = b.toString().getBytes();
            System.arraycopy(tmp, 0, this.theBuffer, 0, tmp.length);
            this.bufferSize = tmp.length;
            this.mode = 1;
            int test = this.read(data);
            return test;
        }
        if (this.names.size() == 0) {
            this.mode = 2;
            return -1;
        }
        String name = (String)this.names.elementAt(0);
        String value = (String)this.values.elementAt(0);
        if (this.files.contains(name)) {
            StringBuffer b = new StringBuffer();
            this.pendingIOStream = this.encodeFile(name, value, b);
            byte[] tmp = b.toString().getBytes();
            System.arraycopy(tmp, 0, this.theBuffer, 0, tmp.length);
            this.bufferSize = tmp.length;
            this.names.removeElementAt(0);
            this.values.removeElementAt(0);
            return this.read(data);
        }
        StringBuffer b = this.encodeNameValue(name, value);
        byte[] tmp = b.toString().getBytes();
        System.arraycopy(tmp, 0, this.theBuffer, 0, tmp.length);
        this.bufferSize = tmp.length;
        this.names.removeElementAt(0);
        this.values.removeElementAt(0);
        return this.read(data);
    }

    private StringBuffer encodeNameValue(String name, String value) {
        StringBuffer s = new StringBuffer();
        s.append("Content-Disposition: form-data; name=\"" + name + "\"");
        s.append("\r\n");
        s.append("\r\n");
        s.append(value);
        s.append("\r\n");
        s.append("--" + boundary);
        if (this.names.size() == 1) {
            s.append("--");
        }
        s.append("\r\n");
        return s;
    }

    private InputStream encodeFile(String name, String value, StringBuffer sb) throws IOException {
        sb.append("Content-Disposition: form-data; name=\"" + name + "\"; " + "filename=\"" + new File(value).getName() + "\"");
        sb.append("\r\n");
        sb.append("Content-Type: application/octet-stream");
        sb.append("\r\n");
        sb.append("\r\n");
        FileInputStream fStream = new FileInputStream(value);
        return fStream;
    }

    private StringBuffer encodeHeader() {
        StringBuffer s = new StringBuffer();
        s.append("--");
        s.append(boundary);
        s.append("\r\n");
        return s;
    }

    String getHeader() {
        return "multipart/form-data; boundary=" + boundary;
    }
}

