/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DCSSRule;
import ice.pilots.html4.DMediaList;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DOM;
import ice.pilots.html4.DRuleList;
import ice.pilots.html4.DStyleDeclaration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class DStyleSheet
implements StyleSheet,
CSSStyleSheet {
    int defaultNamespace;
    private boolean disabled = false;
    private DNode ownerNode;
    private DStyleSheet parentStyleSheet;
    private DCSSRule ownerRule;
    private String href;
    private String title = "";
    private String id;
    DMediaList mediaList;
    private DRuleList ruleList;

    public DStyleSheet(String title, int defaultNamespace, DNode ownerNode, DStyleSheet parentStyleSheet, DCSSRule ownerRule) {
        this(defaultNamespace, ownerNode, parentStyleSheet, ownerRule);
        this.title = title;
    }

    protected DStyleSheet(int defaultNamespace, DNode ownerNode, DStyleSheet parentStyleSheet, DCSSRule ownerRule) {
        this.defaultNamespace = defaultNamespace;
        this.ownerNode = ownerNode;
        this.parentStyleSheet = parentStyleSheet;
        this.ownerRule = ownerRule;
        this.mediaList = new DMediaList();
        this.ruleList = new DRuleList();
        if (ownerNode instanceof Element) {
            this.id = ((Element)((Object)ownerNode)).getAttribute("id");
        }
    }

    public final String getId() {
        return this.id;
    }

    public String getType() {
        return "text/css";
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.mutate();
        if (this.ownerNode != null) {
            DMutationEvent event = (DMutationEvent)this.ownerNode.doc.createDOMEvent(25);
            this.ownerNode.dispatchEvent(event);
        }
    }

    public Node getOwnerNode() {
        return this.ownerNode;
    }

    public StyleSheet getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    public String getHref() {
        return this.href;
    }

    void setHref(String s) {
        this.href = s;
    }

    public String getTitle() {
        return this.title;
    }

    void setTitle(String s) {
        this.title = s;
    }

    public MediaList getMedia() {
        return this.mediaList;
    }

    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    public final CSSRuleList getCssRules() {
        return this.ruleList;
    }

    protected DRuleList getDCssRules() {
        return this.ruleList;
    }

    public int insertRule(String rule, int index) {
        return this.ruleList.insertRule(rule, index);
    }

    public void deleteRule(int index) {
        this.ruleList.deleteRule(index);
    }

    public CSSRuleList getRules() {
        return this.ruleList;
    }

    public void addRule(String sel, String rule) {
        DCSSRule r = new DCSSRule(1, this, null);
        DOM dom = this.ownerNode.doc.getDom();
        DStyleDeclaration dd = dom.createDStyleDeclaration(r, null);
        dd.setCssText(sel + "{" + rule + "}");
    }

    final void mutate() {
        if (this.ownerNode != null) {
            this.ownerNode.getOwnerDDocument().mutate();
        } else if (this.parentStyleSheet != null) {
            this.parentStyleSheet.mutate();
        } else if (this.ownerRule != null) {
            this.ownerRule.mutate();
        }
    }

    protected final void dispatchDOMEvent(short type, String name, String value) {
        if (this.ownerNode != null) {
            DMutationEvent event = (DMutationEvent)this.ownerNode.doc.createDOMEvent(29, this.ownerNode);
            event.setMutationData(null, null, value, name, type);
            this.ownerNode.dispatchEvent(event);
        } else if (this.parentStyleSheet != null) {
            this.parentStyleSheet.dispatchDOMEvent(type, name, value);
        } else if (this.ownerRule != null) {
            this.ownerRule.dispatchDOMEvent(type, name, value);
        }
    }
}

