/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.classfile;

import ice.mozilla.javascript.LabelTable;

class ExceptionTableEntry {
    private int itsStartLabel;
    private int itsEndLabel;
    private int itsHandlerLabel;
    private short itsCatchType;

    ExceptionTableEntry(int startLabel, int endLabel, int handlerLabel, short catchType) {
        this.itsStartLabel = startLabel;
        this.itsEndLabel = endLabel;
        this.itsHandlerLabel = handlerLabel;
        this.itsCatchType = catchType;
    }

    short getStartPC(LabelTable table) {
        short pc = (short)table.getLabelPC(this.itsStartLabel & Integer.MAX_VALUE);
        if (pc == -1) {
            throw new RuntimeException("start label not defined");
        }
        return pc;
    }

    short getEndPC(LabelTable table) {
        short pc = (short)table.getLabelPC(this.itsEndLabel & Integer.MAX_VALUE);
        if (pc == -1) {
            throw new RuntimeException("end label not defined");
        }
        return pc;
    }

    short getHandlerPC(LabelTable table) {
        short pc = (short)table.getLabelPC(this.itsHandlerLabel & Integer.MAX_VALUE);
        if (pc == -1) {
            throw new RuntimeException("handler label not defined");
        }
        return pc;
    }

    short getCatchType() {
        return this.itsCatchType;
    }
}

