/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels;

import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.wizard.CloudMigrationWizardPanel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.SimpleSummaryPanelTreeHelperDWCSPage;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.SimpleSummaryPanelTreeHelperRedshiftPage;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.dialogs.MessageDialog;

public class SimpleSummaryPanel
extends CloudMigrationWizardPanel {
    private static boolean DEBUG = false;
    private Logger simpleSummaryPanelLogger = Logger.getLogger(SimpleSummaryPanel.class.getName());
    private JLabel summaryLabel;
    private JTree jtree;
    private DefaultMutableTreeNode top;
    DefaultTreeModel treeModel;
    private static CloudMigrationController cloudMigrationController;
    private boolean createMode = true;
    private SimpleSummaryPanelTreeHelperRedshiftPage simpleSummaryPanelTreeHelperReshiftPage;
    private SimpleSummaryPanelTreeHelperDWCSPage simpleSummaryPanelTreeHelperDWCSPage;

    @Override
    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
    }

    @Override
    protected void initGui() {
        cloudMigrationController = CloudMigrationController.getInstance();
        try {
            this.summaryLabel = new JLabel(this.nls("SUMMARY_REDSHIFT_DWCS_HEADER_LABEL"));
            Font font = this.summaryLabel.getFont();
            Font font2 = new Font(font.getFontName(), 1, font.getSize());
            this.summaryLabel.setFont(font2);
            JPanel jPanel = LayoutControl.GBC.createPanel();
            int n = 0;
            jPanel.add((Component)this.summaryLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            JPanel jPanel2 = this.getSummaryTreePanel();
            jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            ++n;
            this.add(LayoutControl.GBC.createWizardPanel((Component)jPanel));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.simpleSummaryPanelLogger.severe(throwable.getMessage());
        }
    }

    private JPanel getSummaryTreePanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        this.top = new DefaultMutableTreeNode(this.nls("SUMMARY_TOP_TREENODE_ROOT_DETAILS_LABEL"));
        this.jtree = new JTree(this.top);
        if (this.jtree != null) {
            JScrollPane jScrollPane = new JScrollPane(this.jtree);
            jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            this.simpleSummaryPanelTreeHelperReshiftPage = new SimpleSummaryPanelTreeHelperRedshiftPage(this.jtree);
            this.simpleSummaryPanelTreeHelperDWCSPage = new SimpleSummaryPanelTreeHelperDWCSPage(this.jtree);
        } else {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"initGui jtree is null", (String)"Test", null);
        }
        return jPanel;
    }

    @Override
    protected void updateUIFromModel(CloudMigrationModel cloudMigrationModel) {
        this.treeModel = (DefaultTreeModel)this.jtree.getModel();
        if (this.isCreateMode()) {
            this.createRedshiftTreeNode(cloudMigrationModel);
            this.createDWCSTreeNode(cloudMigrationModel);
            this.setCreateMode(false);
            this.expandTree();
        } else {
            this.editRedshiftTreeNode(cloudMigrationModel);
            this.editDWCSTreeNode(cloudMigrationModel);
        }
    }

    private void expandTree() {
        for (int i = 0; i < this.jtree.getRowCount(); ++i) {
            this.jtree.expandRow(i);
        }
    }

    private void createRedshiftTreeNode(CloudMigrationModel cloudMigrationModel) {
        String string = this.nls("SUMMARY_REDSHIFT_TREENODE_ROOT_LABEL");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.top.add(defaultMutableTreeNode);
        this.simpleSummaryPanelTreeHelperReshiftPage.addRedshiftDatabaseName(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.addSelectedSchemas(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.addMigrationType(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.addAWSAccessKey(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.addSAWSSecretAccess(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.addS3Bucket(defaultMutableTreeNode, cloudMigrationModel);
    }

    private void editRedshiftTreeNode(CloudMigrationModel cloudMigrationModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getChild(this.treeModel.getRoot(), 0);
        this.simpleSummaryPanelTreeHelperReshiftPage.editRedshiftDatabaseName(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.editSelectedSchemas(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.editMigrationType(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.editAWSAccessKey(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.editAWSSecretAccess(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperReshiftPage.editS3Bucket(defaultMutableTreeNode, cloudMigrationModel);
    }

    private void createDWCSTreeNode(CloudMigrationModel cloudMigrationModel) {
        String string = this.nls("SUMMARY_DWCS_TREENODE_ROOT_LABEL");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.top.add(defaultMutableTreeNode);
        this.simpleSummaryPanelTreeHelperDWCSPage.addDWCSTargetConnection(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.addSqldevMetadataRepository(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.addSqldevMetadataRepositoryPassword(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.addRemoveSqldevMetadataRepository(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.addMigrateNow(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.addLocalScriptDirectory(defaultMutableTreeNode, cloudMigrationModel);
    }

    private void editDWCSTreeNode(CloudMigrationModel cloudMigrationModel) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeModel.getChild(this.treeModel.getRoot(), 1);
        if (DEBUG) {
            this.showNodeContents(defaultMutableTreeNode, "editDWCSTreeNode");
        }
        this.simpleSummaryPanelTreeHelperDWCSPage.editDWCSTargetConnection(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.editSqldevMetadataRepository(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.editSqldevMetadataRepositoryPassword(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.editRemoveSqldevMetadataRepository(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.editMigrateNow(defaultMutableTreeNode, cloudMigrationModel);
        this.simpleSummaryPanelTreeHelperDWCSPage.editLocalScriptDirectory(defaultMutableTreeNode, cloudMigrationModel);
    }

    private void showNodeContents(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        System.out.println("[" + string + "] [BEGIN] =====  ");
        System.out.println("[" + string + "]  node=" + defaultMutableTreeNode.toString() + ", childcount=" + defaultMutableTreeNode.getChildCount());
        System.out.println("[" + string + "] -------------  ");
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            System.out.println("[" + string + "] \t childNode=" + defaultMutableTreeNode2.toString() + ", childNode.siblingCount=" + defaultMutableTreeNode2.getSiblingCount());
        }
        System.out.println("[" + string + "] [EXIT]  =====  ");
    }

    @Override
    protected void updateModelFromUI(CloudMigrationModel cloudMigrationModel) {
    }

    @Override
    protected void updateModelFromController(CloudMigrationController cloudMigrationController) {
    }

    private boolean isCreateMode() {
        return this.createMode;
    }

    private void setCreateMode(boolean bl) {
        this.createMode = bl;
    }

    @Override
    protected void validatePage(TraversableContext traversableContext) {
    }
}

