/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.widgets;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.LayoutControl;

public class CheckBoxCardLayoutPanel<V extends Component>
extends JPanel
implements ItemSelectable,
LayoutControl {
    private static final long serialVersionUID = 1L;
    private static final String NULL_PANEL_SELECTOR = "$NULL$";
    private JPanel _nullPanel;
    private JCheckBox _selector;
    private JPanel _container;
    private CardLayout _cardLayout;
    private Map<?, ? extends V> _cardMap;
    private Object _currentSelectorKey;
    private boolean _validateOnChange;

    public CheckBoxCardLayoutPanel(Map<?, ? extends V> map, String string, Type type) {
        this.jbInit(map, string, type, string);
    }

    public CheckBoxCardLayoutPanel(Map<?, ? extends V> map, String string, Type type, String string2) {
        this.jbInit(map, string, type, string2);
    }

    private void jbInit(final Map<?, ? extends V> map, String string, Type type, String string2) {
        Object object;
        Object object22;
        this._cardMap = map;
        this._cardLayout = new CardLayout(0, 0);
        this._nullPanel = new JPanel();
        this._nullPanel.setName("_nullPanel");
        this._container = new JPanel(this._cardLayout);
        this._container.setName("_container");
        if (map.size() == 1) {
            this._container.add((Component)this._nullPanel, NULL_PANEL_SELECTOR);
            for (Object object22 : map.keySet()) {
                this._container.add((Component)map.get(object22), object22.toString());
            }
        }
        if (map.size() >= 2) {
            object = map.keySet();
            object22 = object.iterator();
            String string3 = (String)object22.next();
            String string4 = (String)object22.next();
            this._container.add((Component)map.get(string3), string3);
            this._container.add((Component)map.get(string4), string4);
        }
        this._selector = new JCheckBox(string2);
        this.show(this.getSelection(map));
        this._selector.setName(string + "_CheckBox");
        this._selector.setSelected(false);
        this._selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckBoxCardLayoutPanel.this.show(CheckBoxCardLayoutPanel.this.getSelection(map));
            }
        });
        this.setLayout(new GridBagLayout());
        switch (type) {
            case TITLE_BORDER: {
                this.setBorder(BorderFactory.createTitledBorder(string));
                object = LayoutControl.GBC.createPanel();
                ((Component)object).setName(string + "_TITLE_BORDER.subPanel");
                ((Container)object).add((Component)this._selector, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                ((Container)object).add((Component)this._container, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
                this.add((Component)object, LayoutControl.GBC.TITLED_SUB_PANEL);
                break;
            }
            case PLAIN: {
                object22 = LayoutControl.GBC.createPanel();
                ((Component)object22).setName(string + "_PLAIN_BORDER.selectorPanel");
                if (string != null) {
                    ((Container)object22).add((Component)this._selector, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                } else {
                    ((Container)object22).add((Component)this._selector, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                }
                ((Container)object22).add(Box.createGlue(), LayoutControl.GBC.gbc((int)2, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
                this.add((Component)object22, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                this.add((Component)this._container, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            }
        }
    }

    private void show(Object object) {
        String string = object != null ? object.toString() : NULL_PANEL_SELECTOR;
        this._cardLayout.show(this._container, string);
        this.setCurrentSelectorKey(object);
    }

    private void setCurrentSelectorKey(Object object) {
        this._currentSelectorKey = object;
    }

    public Component getCurrentCard() {
        Component[] componentArray;
        for (Component component : componentArray = this._container.getComponents()) {
            if (!component.isVisible()) continue;
            return component;
        }
        return null;
    }

    public void setValidateOnChange(boolean bl) {
        this._validateOnChange = bl;
    }

    public boolean isValidateOnChange() {
        return this._validateOnChange;
    }

    public void setSelectedAndShowCard(boolean bl) {
        this._selector.setSelected(bl);
        if (this._cardMap != null) {
            this.show(this.getSelection(this._cardMap));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this._selector.setEnabled(bl);
        super.setEnabled(bl);
    }

    public boolean isSelected() {
        return this._selector.isSelected();
    }

    public String getSelection(Map<?, ? extends V> map) {
        String string = null;
        boolean bl = this._selector.isSelected();
        if (map != null) {
            Set<?> set = map.keySet();
            String[] stringArray = new String[set.size()];
            set.toArray(stringArray);
            if (stringArray.length == 1) {
                string = !bl ? null : stringArray[0];
            }
            if (stringArray.length >= 2) {
                string = bl ? stringArray[1] : stringArray[0];
            }
        }
        return string;
    }

    public String getSelectionOriginal(Map<?, ? extends V> map) {
        Set<?> set;
        boolean bl = this._selector.isSelected();
        if (bl && (set = map.keySet()).size() == 1) {
            Iterator<?> iterator = set.iterator();
            return (String)iterator.next();
        }
        return null;
    }

    public ArrayList<JPanel> getCardMapPanels() {
        Set<?> set;
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        if (this._cardMap != null && (set = this._cardMap.keySet()).size() == 2) {
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add((JPanel)this._cardMap.get(iterator.next()));
            }
        }
        return arrayList;
    }

    public ArrayList<Component> getActivePanelComponents() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        ArrayList<JPanel> arrayList2 = this.getCardMapPanels();
        if (arrayList2.size() == 2) {
            for (JPanel jPanel : arrayList2) {
                Component[] componentArray;
                if (jPanel.getComponentCount() <= 0) continue;
                for (Component component : componentArray = jPanel.getComponents()) {
                    if (component instanceof Box.Filler) continue;
                    arrayList.add(component);
                }
            }
        }
        return arrayList;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this._selector.addItemListener(itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this._selector.removeItemListener(itemListener);
    }

    @Override
    public Object[] getSelectedObjects() {
        return this._selector.getSelectedObjects();
    }

    public void addActionListener(ActionListener actionListener) {
        this._selector.addActionListener(actionListener);
    }

    public static enum Type {
        PLAIN,
        TITLE_BORDER;

    }
}

