/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.validate;

import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftAccessKeySecretAccessS3BucketValidator;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.migration.cloud.ui.validate.DWCSConnectionValidationException;
import oracle.dbtools.migration.cloud.ui.validate.LocalScriptDirectoryValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftAccessKeySecretAccessS3BucketValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftAccessKeyValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftConnectionValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftS3BucketValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftSecretAccessValidationException;
import oracle.dbtools.raptor.utils.Connections;

public class Validator {
    public static void validateRedshiftConnection(String string) throws RedshiftConnectionValidationException {
        if (string == null || string.length() == 0) {
            throw new RedshiftConnectionValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_CONNECTION_NOTSELECTED"));
        }
    }

    public static void validateSelectedSchemas(String[] stringArray) throws RedshiftConnectionValidationException {
        if (stringArray == null || stringArray.length == 0) {
            throw new RedshiftConnectionValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_NO_SELECTED_SCHEMAS"));
        }
    }

    public static void validateRedshiftAccessKey(String string) throws RedshiftAccessKeyValidationException {
        if (string == null || string.length() == 0) {
            throw new RedshiftAccessKeyValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_ACCESS_KEY_EMPTY"));
        }
    }

    public static void validateRedshiftSecretAccess(String string) throws RedshiftSecretAccessValidationException {
        if (string == null || string.length() == 0) {
            throw new RedshiftSecretAccessValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_SECURE_ACCESS_EMPTY"));
        }
    }

    public static void validateRedshift3Bucket(String string) throws RedshiftS3BucketValidationException {
        if (string == null || string.length() == 0) {
            throw new RedshiftS3BucketValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_S3BUCKET_EMPTY"));
        }
        if (!MigrationUtilities.isValidateS3BucketURLString(string)) {
            throw new RedshiftS3BucketValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_S3BUCKET_NO_HTTPS"));
        }
    }

    public static void validateDWCSConnection(String string) throws DWCSConnectionValidationException {
        if (string == null || string.length() == 0) {
            throw new DWCSConnectionValidationException(Utilities.nls("VALIDATION_ERROR_DWCS_CONNECTION_NOTSELECTED"));
        }
        String string2 = Connections.getInstance().getConnectionInfo(string).getProperty("user");
        if (!string2.equalsIgnoreCase("admin")) {
            throw new DWCSConnectionValidationException(Utilities.nls("VALIDATION_ERROR_DWCS_CONNECTION_NOT_ADMIN"));
        }
    }

    public static void validateAvailablechemas(String[] stringArray, String[] stringArray2) throws RedshiftConnectionValidationException {
        if (!(stringArray != null && stringArray.length != 0 || stringArray2 != null && stringArray2.length != 0)) {
            throw new RedshiftConnectionValidationException(Utilities.nls("VALIDATION_ERROR_REDSHIFT_NO_AVAILABLE_SCHEMAS"));
        }
    }

    public static void validateLocalScriptDirectory(String string) throws LocalScriptDirectoryValidationException {
        if (string == null || string.length() == 0) {
            throw new LocalScriptDirectoryValidationException(Utilities.nls("VALIDATION_ERROR_LOCAL_SCRIPT_DIRECTORY_MISSING"));
        }
    }

    public static void validateRedshiftAccessKeySecretAccessS3Bucket(CloudMigrationModel cloudMigrationModel) throws RedshiftAccessKeySecretAccessS3BucketValidationException, Exception {
        String string = cloudMigrationModel.getSourceConnection();
        String[] stringArray = cloudMigrationModel.getSelectedSchemas();
        String string2 = cloudMigrationModel.getString("REDSHIFT_AWS_ACCESS_TYPE_KEY");
        String string3 = cloudMigrationModel.getString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY");
        String string4 = cloudMigrationModel.getString("REDSHIFT_S3_BUCKET_KEY");
        if (string != null || string.length() != 0 || stringArray[0] != null || stringArray[0].length() != 0 || string2 != null || string2.length() != 0 || string3 != null || string3.length() != 0 || string4 != null || string4.length() != 0) {
            String string5 = RedshiftAccessKeySecretAccessS3BucketValidator.validateRedshiftAccessKeySecretAccessS3Bucket(string, stringArray, string2, string3, string4);
            if (string5 != null) {
                throw new RedshiftAccessKeySecretAccessS3BucketValidationException(string5);
            }
            return;
        }
    }
}

