/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.backendDelegation;

import java.awt.Component;
import java.util.logging.Logger;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;

public class BackendDelegatorWorker
implements Runnable {
    private Logger logger = Logger.getLogger(BackendDelegatorWorker.class.getName());
    private DeterminateProgressMonitor progressMonitor;
    private String message;
    private String title;
    private int stepsCompleted;
    private String result = "Task in progress";
    private String redShiftDatabase;
    private String targetDatabase;
    private String s3Bucket;
    private String awsSecureAccess;
    private String awsAccessKey;
    private String[] selectedSchemas;
    private String migrationType;
    private String[] availableSchemas;
    private Boolean migrationNow = false;
    private String scriptsInDirectory = null;

    public BackendDelegatorWorker(Component component, String string, String string2) {
        this.message = string2;
        this.title = string;
        this.setStepsCompleted(0);
        this.progressMonitor = new DeterminateProgressMonitor(component, string, (Object)"Redshift Migration in action", string2);
        this.progressMonitor.setMinimum(0);
        this.progressMonitor.setBarVisible(true);
        this.progressMonitor.setMaximum(100);
        this.progressMonitor.setMillisToDecideToPopup(0);
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
    }

    public boolean doTestRunForProgressMonitor() {
        System.out.println("BackendDelegatorWorker.RUN ..." + Thread.currentThread().getId());
        this.logger.info("BackendDelegatorWorker.RUN ..." + Thread.currentThread().getId());
        for (int i = 10; i <= 100; i += 10) {
            this.setResult("Task in progress");
            try {
                Thread.sleep(50L);
                if (this.progressMonitor.isCanceled()) {
                    this.setResult("Task Aborted");
                    this.progressMonitor.close();
                    return false;
                }
                this.setStepsCompleted(i);
                this.progressMonitor.setProgress(this.getStepsCompleted());
                this.progressMonitor.getPanel().setNote("Percentage completed=" + this.getStepsCompleted());
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setResult("Task completed");
        this.progressMonitor.finish();
        this.progressMonitor.close();
        this.logger.info("BackendDelegatorWorker.RUN ..." + Thread.currentThread().getId() + "... over!");
        return true;
    }

    private void updateProgressMonitor(int n, int n2, String string) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = this.progressMonitor.getMinimum();
        int n4 = this.progressMonitor.getMaximum();
        double d = (double)n / (double)n2 * (double)(n4 - n3);
        this.setStepsCompleted((int)d);
        this.progressMonitor.setProgress(this.getStepsCompleted());
        this.progressMonitor.getPanel().setNote("Percentage completed=" + this.getStepsCompleted() + ": " + string);
    }

    private void printRedshiftData() {
        System.out.println("BackendDelegatorWorker.doMigrationWork.....Test Redshift input data ...");
        System.out.println("BackendDelegatorWorker.printRedshiftData.getRedShiftDatabase() = " + this.getRedShiftDatabase());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getTargetDatabase() = " + this.getTargetDatabase());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getMigrationType() = " + this.getMigrationType());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getAWSAccessKey() = " + this.getAWSAccessKey());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getAWSSecureAccess() = " + this.getAWSSecureAccess());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getS3Bucket() = " + this.getS3Bucket());
        if (this.getAvailableSchemas() != null && this.getAvailableSchemas().length > 0) {
            for (String string : this.getAvailableSchemas()) {
                System.out.println("BackendDelegatorWorker.printRedshiftData.available_schema = " + string);
            }
        } else {
            System.out.println("BackendDelegatorWorker.printRedshiftData.available_schemas = NO AVAILABLE DATABASES.");
        }
        if (this.getSelectedSchemas() != null && this.getSelectedSchemas().length > 0) {
            for (String string : this.getSelectedSchemas()) {
                System.out.println("BackendDelegatorWorker.printRedshiftData.selected_schema = " + string);
            }
        } else {
            System.out.println("BackendDelegatorWorker.printRedshiftData.selected_schemas = NO SELECTED DATABASES.");
        }
        System.out.println("BackendDelegatorWorker.printRedshiftData.getMigrationNow() = " + this.getMigrationNow());
        System.out.println("BackendDelegatorWorker.printRedshiftData.getScriptsInDirectory() = " + this.getScriptsInDirectory());
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String string) {
        this.result = string;
    }

    public boolean hasUserCancelled() {
        return this.progressMonitor.isCanceled();
    }

    public int getStepsCompleted() {
        return this.stepsCompleted;
    }

    public void setStepsCompleted(int n) {
        this.stepsCompleted = n;
    }

    public void setRedshiftDatabase(String string) {
        this.redShiftDatabase = string;
    }

    public void setTargetDatabase(String string) {
        this.targetDatabase = string;
    }

    public void setS3Bucket(String string) {
        this.s3Bucket = string;
    }

    public void setAWSSecureAccess(String string) {
        this.awsSecureAccess = string;
    }

    public void setAWSAccessKey(String string) {
        this.awsAccessKey = string;
    }

    public void setSelectedSchemas(String[] stringArray) {
        this.selectedSchemas = stringArray;
    }

    public void setAvailableSchemas(String[] stringArray) {
        this.availableSchemas = stringArray;
    }

    public void setMigrationType(String string) {
        this.migrationType = string;
    }

    public String getRedShiftDatabase() {
        return this.redShiftDatabase;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public String getMigrationType() {
        return this.migrationType;
    }

    public String getAWSAccessKey() {
        return this.awsAccessKey;
    }

    public String getAWSSecureAccess() {
        return this.awsSecureAccess;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String[] getAvailableSchemas() {
        return this.availableSchemas;
    }

    public String[] getSelectedSchemas() {
        return this.selectedSchemas;
    }

    private Boolean getMigrationNow() {
        return this.migrationNow;
    }

    public void setMigrationNow(Boolean bl) {
        this.migrationNow = bl;
    }

    private String getScriptsInDirectory() {
        return this.scriptsInDirectory;
    }

    public void setScriptsInDirectory(String string) {
        this.scriptsInDirectory = string;
    }
}

