/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.metadata.repository;

import java.io.IOException;
import oracle.dbtools.migration.cloud.core.utils.MigrationConstants;
import oracle.dbtools.migration.cloud.core.utils.RunSQLcl;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;

public class MigrationRepository {
    private RunSQLcl m_runSQLcl;
    private String m_targetUserName;

    public MigrationRepository(RunSQLcl runSQLcl, String string) {
        this.m_runSQLcl = runSQLcl;
        this.m_targetUserName = string;
    }

    public boolean createMigrationRepository() throws SQLCLException, IOException {
        this.getRunSQLcl().runSQLScript("SET SERVEROUTPUT ON");
        this.getRunSQLcl().runSQLScript(MigrationConstants.m_alterSessionToSqldevMigRepos);
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_REPOSITORY.pls");
        this.getRunSQLcl().runSQLScript("EXECUTE MIGRATION_REPOSITORY.createAllRepositoryTables()");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_REPOSITORY_QUERY.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_SESSIONSTATE.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/metadata/repository/plsql/MIGRATION_TRANSFORMER.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/capture/redshift/plsql/REDSHIFT_CAPTURE.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/convert/plsql/MIGRATION_CONVERT.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/generate/plsql/MIGRATION_GENERATOR.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/deploy/redshift/plsql/REDSHIFT_DEPLOY.pls");
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/scheduler/plsql/MIGRATION_SCHEDULER.pls");
        this.createAndCompileMigrationUtilitiesPackage();
        return true;
    }

    public void createAndCompileMigrationUtilitiesPackage() throws SQLCLException, IOException {
        this.getRunSQLcl().runSQLScript("SET SERVEROUTPUT ON");
        this.getRunSQLcl().runSQLScript("ALTER SESSION SET CURRENT_SCHEMA=<username>".replace("<username>", this.m_targetUserName));
        this.getRunSQLcl().runSQLFile("oracle/dbtools/migration/cloud/metadata/repository/plsql/REDSHIFT_MIGRATION_UTILITIES.pls");
        this.getRunSQLcl().runSQLScript(MigrationConstants.m_alterSessionToSqldevMigRepos);
    }

    public boolean dropMigrationRepository() throws SQLCLException {
        this.getRunSQLcl().runSQLScript("EXECUTE MIGRATION_REPOSITORY.dropAllRepositoryTables()");
        this.getRunSQLcl().runSQLScript("DROP package MIGRATION_REPOSITORY");
        return true;
    }

    public boolean truncateMigrationRepository() throws SQLCLException {
        this.getRunSQLcl().runSQLScript("EXECUTE MIGRATION_REPOSITORY.truncateAllRepositoryTables()");
        return true;
    }

    public RunSQLcl getRunSQLcl() {
        return this.m_runSQLcl;
    }
}

