/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.api.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.core.api.CloudMigrationInputDataHandler;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftPreferenceSettings;
import oracle.dbtools.migration.cloud.core.utils.MigrationConstants;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.core.utils.log.CoreLogger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class RedshiftMigrationUIDataInput
extends CloudMigrationInputDataHandler {
    protected static boolean DEBUG = false;
    private String m_targetUserName;
    private String m_targetConnectionURL;
    private String m_fileFormatDelimiter;
    private String m_awsS3BucketHTTPSLocation;
    private String m_awsS3BucketURI;
    private String m_redshiftSourceReposName;
    private String m_awsAccessKey = null;
    private String m_awsSecretAccess = null;
    private String[] m_sourceSelectedSchemas;
    private String[] m_sourcePreviousSchemas;
    private String[] m_sourceUpdatedDeployableSchemas;
    private String m_sqlScriptDirectory = null;
    private boolean m_startDeployment = false;
    private String m_migrationType = null;
    private String m_migrationRepositoryPassword = null;
    private boolean m_dropMigrationRepository = false;
    private RedshiftPreferenceSettings preferenceSettings = null;
    private CoreLogger coreLogger = null;

    @Override
    public Connection getSourceConnection() {
        return this.m_sourceConnection;
    }

    @Override
    public void setSourceConnection(Connection connection) {
        this.m_sourceConnection = connection;
    }

    @Override
    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    @Override
    public void setTargetConnection(Connection connection) {
        this.m_targetConnection = connection;
    }

    @Override
    public String getSourceConnectionString() {
        return this.m_sourceConnectionString;
    }

    @Override
    public void setSourceConnectionString(String string) {
        this.m_sourceConnectionString = string;
        this.setSourceRepositoryConnectionName(Connections.getConnectionName((String)string));
    }

    @Override
    public String getTargetConnectionString() {
        return this.m_targetConnectionString;
    }

    @Override
    public void setTargetConnectionString(String string) throws DBException, SQLException, Exception {
        this.m_targetConnectionString = string;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("user") + "/" + properties.getProperty("password") + "@" + properties.getProperty("customUrl");
        this.setTargetConnectionURL(string2);
        this.setTargetConnection(Connections.getInstance().getUniqueConnection(string));
        String string3 = properties.getProperty("user");
        this.setTargetUserName(string3);
        this.checkIfMigrationReposExists(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfMigrationReposExists(String string) throws SQLException, Exception {
        Connection connection = null;
        try {
            SQLException sQLException;
            connection = Connections.getInstance().getUniqueConnection(string);
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            if ("sqldev_migrepos".equalsIgnoreCase(dBUtil.executeReturnOneCol(MigrationConstants.migrationReposCheckQuery))) {
                dBUtil.execute("DROP USER sqldev_migrepos CASCADE");
                dBUtil.execute("drop PACKAGE redshift_migration_utilities;");
            }
            boolean bl = dBUtil.execute(MigrationConstants.createUserSQLScript[0].replace("<username>", "sqldev_migrepos").replace("<password>", this.getMigrationRepositoryPassword()));
            boolean bl2 = dBUtil.execute(MigrationConstants.createUserSQLScript[1].replace("<username>", "sqldev_migrepos"));
            boolean bl3 = dBUtil.execute(MigrationConstants.createUserSQLScript[2].replace("<username>", "sqldev_migrepos"));
            boolean bl4 = dBUtil.execute(MigrationConstants.createUserSQLScript[3].replace("<username>", "sqldev_migrepos"));
            boolean bl5 = dBUtil.execute(MigrationConstants.createUserSQLScript[4].replace("<username>", "sqldev_migrepos"));
            if (DEBUG) {
                System.out.println("b1=" + bl);
                System.out.println("b2=" + bl2);
                System.out.println("b3=" + bl3);
                System.out.println("b4=" + bl4);
                System.out.println("b5=" + bl5);
            }
            if ((sQLException = dBUtil.getLastException()) != null) {
                throw sQLException;
            }
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
    }

    @Override
    public String getProjectName() {
        return this.m_projectName;
    }

    @Override
    public void setProjectName(String string) {
        this.m_projectName = string;
    }

    @Override
    public String[] getSourceDatabases() {
        return this.m_sourceDatabases;
    }

    @Override
    public void setSourceDatabases(String[] stringArray) {
        this.m_sourceDatabases = stringArray;
    }

    @Override
    public void setMigrationChoice(int n) {
        this.m_migrationChoice = n;
    }

    @Override
    public int getMigrationChoice() {
        return this.m_migrationChoice;
    }

    @Override
    public boolean isTruncateMigrationRepository() {
        return this.m_truncateMigrationRepository;
    }

    @Override
    public void setTruncateMigrationRepository(boolean bl) {
        this.m_truncateMigrationRepository = bl;
    }

    public String getAwsS3BucketURI() {
        return this.m_awsS3BucketURI;
    }

    public void setAwsS3BucketURI(String string) {
        this.m_awsS3BucketURI = string;
    }

    public String getSourceRepositoryConnectionName() {
        return this.m_redshiftSourceReposName;
    }

    public void setSourceRepositoryConnectionName(String string) {
        this.m_redshiftSourceReposName = string;
    }

    public String getTargetConnectionURL() {
        return this.m_targetConnectionURL;
    }

    public void setTargetConnectionURL(String string) {
        this.m_targetConnectionURL = string;
    }

    public String getFileFormatDelimiter() {
        return this.m_fileFormatDelimiter;
    }

    public void setFileFormatDelimiter(String string) {
        this.m_fileFormatDelimiter = string;
    }

    public String getAwsAccessKey() {
        return this.m_awsAccessKey;
    }

    public void setAwsAccessKey(String string) {
        this.m_awsAccessKey = string;
    }

    public String getAwsSecretAccess() {
        return this.m_awsSecretAccess;
    }

    public void setAwsSecretAccess(String string) {
        this.m_awsSecretAccess = string;
    }

    public String[] getSourceSelectedSchemas() {
        return this.m_sourceSelectedSchemas;
    }

    public void setSourceSelectedSchemas(String[] stringArray) {
        this.m_sourceSelectedSchemas = stringArray;
    }

    public String[] getSourcePreviousSchemas() {
        return this.m_sourcePreviousSchemas;
    }

    public void setSourcePreviousSchemas(String[] stringArray) {
        this.m_sourcePreviousSchemas = stringArray;
    }

    public String[] getSourceUpdatedDeployableSchemas() {
        return this.m_sourceUpdatedDeployableSchemas;
    }

    public void setSourceUpdatedDeployableSchemas(String[] stringArray) {
        this.m_sourceUpdatedDeployableSchemas = stringArray;
    }

    public String getAwsS3BucketHTTPSLocation() {
        return this.m_awsS3BucketHTTPSLocation;
    }

    public void setAwsS3BucketHTTPSLocation(String string) {
        this.m_awsS3BucketHTTPSLocation = string;
        this.m_awsS3BucketURI = MigrationUtilities.generateS3BucketStringFromURL(string);
    }

    public String getSqlScriptDirectory() {
        return this.m_sqlScriptDirectory;
    }

    public void setSqlScriptDirectory(String string) {
        this.m_sqlScriptDirectory = string;
    }

    public boolean isStartDeployment() {
        return this.m_startDeployment;
    }

    public void setStartDeployment(boolean bl) {
        this.m_startDeployment = bl;
    }

    public String getMigrationType() {
        return this.m_migrationType;
    }

    public void setMigrationType(String string) {
        this.m_migrationType = string;
    }

    public void setUserPreferences(HashMap<String, Object> hashMap) {
        this.preferenceSettings = new RedshiftPreferenceSettings(hashMap);
    }

    public RedshiftPreferenceSettings getUserPreferences() {
        return this.preferenceSettings;
    }

    @Override
    public boolean isDropMigrationRepository() {
        return this.m_dropMigrationRepository;
    }

    @Override
    public void setDropMigrationRepository(boolean bl) {
        this.m_dropMigrationRepository = bl;
    }

    @Override
    public String getMigrationRepositoryPassword() {
        return this.m_migrationRepositoryPassword;
    }

    @Override
    public void setMigrationRepositoryPassword(String string) {
        this.m_migrationRepositoryPassword = MigrationUtilities.addDoubleQuotes(string);
    }

    public String getTargetUserName() {
        return this.m_targetUserName;
    }

    public void setTargetUserName(String string) {
        this.m_targetUserName = string;
    }

    public Boolean isUseDBMSSchedulerChecked() {
        RedshiftPreferenceSettings redshiftPreferenceSettings = this.getUserPreferences();
        if (redshiftPreferenceSettings != null) {
            return redshiftPreferenceSettings.isUseDBMSSchedulerChecked();
        }
        return false;
    }

    public String getDBMSSchedulerType() {
        RedshiftPreferenceSettings redshiftPreferenceSettings = this.getUserPreferences();
        if (redshiftPreferenceSettings != null) {
            return redshiftPreferenceSettings.getDBMSSchedulerType();
        }
        return null;
    }
}

