/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.capture.redshift.online;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.capture.redshift.online.AWSDataUnloadAndADWCDataLoadTask;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftMigrationUIDataInput;
import oracle.dbtools.migration.cloud.core.utils.MigrationUtilities;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorMultiTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.db.ConnectionException;

public class RedshiftDataUnloadAndLoad {
    private LinkedHashMap<String, String> m_unloadCommandsHash = new LinkedHashMap();
    private LinkedHashMap<String, String> m_dataLoadCommandsHash = new LinkedHashMap();
    private LinkedHashMap<String, String> m_dataLoadSchedulerCommandsHash = new LinkedHashMap();
    private LinkedHashMap<String, String> m_unloadCommandsHashSelected = new LinkedHashMap();
    private LinkedHashMap<String, String> m_dataLoadCommandsHashSelected = new LinkedHashMap();
    private LinkedHashMap<String, String> m_table_rowsHash_selected = new LinkedHashMap();
    private int m_total_tables_selected;
    private String[] m_newDeployableSchemas;
    private int m_noOfMaxThreads;
    private String m_sqlScriptDirectory = null;
    private boolean m_startDeployment = false;
    private String m_awsAccessKey;
    private String m_awsSecretAccess;
    private String m_targetConnectionName;
    private String m_sourceConnectionName;
    private boolean m_isUseJobScheduler;
    private String m_utilPkgString = null;
    private boolean isDataLoadComplete = false;
    private static final boolean DEBUG = false;
    private HashMap<String, String> m_statusDataLoadTables = new HashMap();

    public RedshiftDataUnloadAndLoad(RedshiftMigrationUIDataInput redshiftMigrationUIDataInput) {
        this.m_sqlScriptDirectory = redshiftMigrationUIDataInput.getSqlScriptDirectory();
        this.m_startDeployment = redshiftMigrationUIDataInput.isStartDeployment();
        this.m_targetConnectionName = redshiftMigrationUIDataInput.getTargetConnectionString();
        this.m_sourceConnectionName = redshiftMigrationUIDataInput.getSourceConnectionString();
        this.m_awsAccessKey = redshiftMigrationUIDataInput.getAwsAccessKey();
        this.m_awsSecretAccess = redshiftMigrationUIDataInput.getAwsSecretAccess();
        this.m_noOfMaxThreads = redshiftMigrationUIDataInput.getUserPreferences().getMaxNumberThreads();
        this.m_isUseJobScheduler = redshiftMigrationUIDataInput.getUserPreferences().isUseDBMSSchedulerChecked();
        this.m_newDeployableSchemas = redshiftMigrationUIDataInput.getSourceUpdatedDeployableSchemas();
        if (this.m_newDeployableSchemas == null || this.m_newDeployableSchemas.length == 0) {
            this.m_startDeployment = false;
        }
    }

    public void writeUnloadAndDataLoadSqlScripts(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.writeUnloadAWSRedshiftS3Data(backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        this.writeDataLoadToDwcsSqlScripts(backendDelegatorRaptorTask);
    }

    public void writeUnloadAWSRedshiftS3Data(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_unloadCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        if (this.m_sqlScriptDirectory != null) {
            this.writeRedshiftUnloadScript();
        }
    }

    public void writeDataLoadToDwcsSqlScripts(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_dataLoadCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'OCA_COPY_DATA' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        this.m_dataLoadSchedulerCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'JOB_SCHEDULER' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        if (this.m_sqlScriptDirectory != null) {
            this.getUtilPackageString();
            this.writeDWCSDataLoadScript();
            this.writeDWCSDataLoadForJobScheduler();
        }
    }

    public void startUnloadToS3AndLoadToAdwc(final BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_unloadCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_dataLoadCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'OCA_COPY_DATA' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_dataLoadSchedulerCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'JOB_SCHEDULER' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        if (this.m_sqlScriptDirectory != null) {
            backendDelegatorRaptorTask.checkCanProceed();
            this.writeRedshiftUnloadScript();
            this.getUtilPackageString();
            backendDelegatorRaptorTask.checkCanProceed();
            this.writeDWCSDataLoadScript();
            backendDelegatorRaptorTask.checkCanProceed();
            this.writeDWCSDataLoadForJobScheduler();
        }
        if (this.m_startDeployment && this.m_newDeployableSchemas.length > 0) {
            int n = 1;
            backendDelegatorRaptorTask.checkCanProceed();
            this.m_unloadCommandsHashSelected = this.getSqlScriptCommands(this.getS3UnloadScripts(this.m_newDeployableSchemas), backendDelegatorRaptorTask);
            backendDelegatorRaptorTask.checkCanProceed();
            this.m_dataLoadCommandsHashSelected = this.getSqlScriptCommands(this.getDataLoadScripts(this.m_newDeployableSchemas), backendDelegatorRaptorTask);
            this.m_table_rowsHash_selected = this.getSqlScriptCommands(this.getRowHashScripts(this.m_newDeployableSchemas), backendDelegatorRaptorTask);
            this.m_total_tables_selected = Integer.parseInt(this.getTotalNumberOfTablesSelected(this.getGetTableSelectedScripts(this.m_newDeployableSchemas)));
            final RaptorMultiTask raptorMultiTask = new RaptorMultiTask("AWSDataUnloadAndADWCDataLoadTask", true, IRaptorTaskRunMode.TASKVIEWER);
            raptorMultiTask.setParallelism(this.m_noOfMaxThreads - 1);
            Set<String> set = this.m_unloadCommandsHashSelected.keySet();
            for (String string : set) {
                String string2 = MessageFormat.format(CloudMigrationsResources.getString("REDSHIFT_DATA_UNLOAD_MESG"), n, this.m_total_tables_selected, string, this.m_table_rowsHash_selected.get(string));
                String string3 = MessageFormat.format(CloudMigrationsResources.getString("ADWC_DATA_UNLOAD_MESG"), n, this.m_total_tables_selected, string, this.m_table_rowsHash_selected.get(string));
                AWSDataUnloadAndADWCDataLoadTask aWSDataUnloadAndADWCDataLoadTask = this.createAWSDataUnloadAndADWCDataLoadTaskSelected("AWSDataUnloadAndADWCDataLoadThread", string, backendDelegatorRaptorTask, string2, string3);
                raptorMultiTask.addTask((RaptorTask)aWSDataUnloadAndADWCDataLoadTask);
                backendDelegatorRaptorTask.checkCanProceed();
                if (n == this.m_total_tables_selected) {
                    raptorMultiTask.setCancellable(true);
                    raptorMultiTask.setPausable(false);
                    RaptorTaskDescriptor raptorTaskDescriptor = raptorMultiTask.getDescriptor();
                    raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            List list = raptorMultiTask.getFinishedTasks();
                            for (int i = 0; i < list.size(); ++i) {
                                RedshiftDataUnloadAndLoad.this.traceFlow(" TableName " + ((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName());
                                RedshiftDataUnloadAndLoad.this.m_statusDataLoadTables.put(((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName(), Utilities.nls("DATALOAD_SUCCESSS"));
                            }
                            RedshiftDataUnloadAndLoad.this.resumeBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
                            backendDelegatorRaptorTask.setMessage(Utilities.nls("TASK9_COMPLETED"));
                        }

                        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                            RedshiftDataUnloadAndLoad.this.traceFlow(" IN TASK FAILED  -dataUnloadAndLoadTasks");
                            List list = raptorMultiTask.getFailedTasks();
                            for (int i = 0; i < list.size(); ++i) {
                                RedshiftDataUnloadAndLoad.this.traceFlow(" Failed Tasks " + list.get(i));
                                RedshiftDataUnloadAndLoad.this.traceFlow(" TableName " + ((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName());
                                RedshiftDataUnloadAndLoad.this.m_statusDataLoadTables.put(((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName(), Utilities.nls("DATALOAD_FAILURE"));
                            }
                            RedshiftDataUnloadAndLoad.this.resumeBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
                            backendDelegatorRaptorTask.setMessage(Utilities.nls("TASK9_COMPLETED"));
                        }

                        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                            RedshiftDataUnloadAndLoad.this.traceFlow(" IN TASK CANCELLED  -dataUnloadAndLoadTasks");
                            List list = raptorMultiTask.getCancelledTasks();
                            for (int i = 0; i < list.size(); ++i) {
                                RedshiftDataUnloadAndLoad.this.traceFlow(" Failed Tasks " + list.get(i));
                                RedshiftDataUnloadAndLoad.this.traceFlow(" TableName " + ((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName());
                                RedshiftDataUnloadAndLoad.this.m_statusDataLoadTables.put(((AWSDataUnloadAndADWCDataLoadTask)((Object)list.get(i))).getSchemaTableName(), Utilities.nls("DATALOAD_CANCELLED"));
                            }
                            RedshiftDataUnloadAndLoad.this.resumeBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
                        }
                    });
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorMultiTask);
                    this.setWaitForBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
                }
                ++n;
                backendDelegatorRaptorTask.checkCanProceed();
            }
        }
    }

    private AWSDataUnloadAndADWCDataLoadTask createAWSDataUnloadAndADWCDataLoadTask(String string, String string2, BackendDelegatorRaptorTask backendDelegatorRaptorTask, String string3, String string4) {
        AWSDataUnloadAndADWCDataLoadTask aWSDataUnloadAndADWCDataLoadTask = new AWSDataUnloadAndADWCDataLoadTask(string);
        aWSDataUnloadAndADWCDataLoadTask.setTargetConnectionName(this.m_targetConnectionName);
        aWSDataUnloadAndADWCDataLoadTask.setSourceConnectionName(this.m_sourceConnectionName);
        aWSDataUnloadAndADWCDataLoadTask.setSourceSQLScript(this.m_unloadCommandsHash.get(string2));
        aWSDataUnloadAndADWCDataLoadTask.setTargetSQLScript(this.m_dataLoadCommandsHash.get(string2));
        aWSDataUnloadAndADWCDataLoadTask.setDataUnLoadMessage(string3);
        aWSDataUnloadAndADWCDataLoadTask.setDataLoadMessage(string4);
        aWSDataUnloadAndADWCDataLoadTask.setSchemaTableName(string2);
        aWSDataUnloadAndADWCDataLoadTask.setBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
        return aWSDataUnloadAndADWCDataLoadTask;
    }

    private AWSDataUnloadAndADWCDataLoadTask createAWSDataUnloadAndADWCDataLoadTaskSelected(String string, String string2, BackendDelegatorRaptorTask backendDelegatorRaptorTask, String string3, String string4) {
        AWSDataUnloadAndADWCDataLoadTask aWSDataUnloadAndADWCDataLoadTask = new AWSDataUnloadAndADWCDataLoadTask(string);
        aWSDataUnloadAndADWCDataLoadTask.setTargetConnectionName(this.m_targetConnectionName);
        aWSDataUnloadAndADWCDataLoadTask.setSourceConnectionName(this.m_sourceConnectionName);
        aWSDataUnloadAndADWCDataLoadTask.setSourceSQLScript(this.m_unloadCommandsHashSelected.get(string2));
        aWSDataUnloadAndADWCDataLoadTask.setTargetSQLScript(this.m_dataLoadCommandsHashSelected.get(string2));
        aWSDataUnloadAndADWCDataLoadTask.setDataUnLoadMessage(string3);
        aWSDataUnloadAndADWCDataLoadTask.setDataLoadMessage(string4);
        aWSDataUnloadAndADWCDataLoadTask.setSchemaTableName(string2);
        aWSDataUnloadAndADWCDataLoadTask.setBackendDelegatorRaptorTask(backendDelegatorRaptorTask);
        return aWSDataUnloadAndADWCDataLoadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUnloadAWSRedshiftDataIntoS3(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.m_unloadCommandsHash = this.getSqlScriptCommands("SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc", backendDelegatorRaptorTask);
        backendDelegatorRaptorTask.checkCanProceed();
        if (this.m_sqlScriptDirectory != null) {
            this.writeRedshiftUnloadScript();
        }
        backendDelegatorRaptorTask.checkCanProceed();
        if (this.m_startDeployment) {
            Statement statement = null;
            Connection connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_sourceConnectionName);
            try {
                statement = connection.createStatement();
                Set<String> set = this.m_unloadCommandsHash.keySet();
                for (String string : set) {
                    String string2 = this.m_unloadCommandsHash.get(string);
                    statement.execute(this.m_unloadCommandsHash.get(string));
                    backendDelegatorRaptorTask.checkCanProceed();
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    public void startDataLoadToDwcs(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws IOException, SQLCLException, SQLException, ConnectionException, Exception {
        backendDelegatorRaptorTask.checkCanProceed();
        this.writeDataLoadToDwcsSqlScripts(backendDelegatorRaptorTask);
        if (this.m_startDeployment) {
            Set<String> set = this.m_unloadCommandsHash.keySet();
            for (String string : set) {
                String string2 = this.m_dataLoadCommandsHash.get(string);
                this.executeDataLoadScript(this.m_dataLoadCommandsHash.get(string), backendDelegatorRaptorTask);
                backendDelegatorRaptorTask.checkCanProceed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDataLoadScript(String string, BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, ConnectionException, ExecutionException {
        OracleCallableStatement oracleCallableStatement = null;
        Connection connection = null;
        backendDelegatorRaptorTask.checkCanProceed();
        try {
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_targetConnectionName);
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
            backendDelegatorRaptorTask.checkCanProceed();
            oracleCallableStatement.execute();
            backendDelegatorRaptorTask.checkCanProceed();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, String> getSqlScriptCommands(String string, BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        ResultSet resultSet = null;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Connection connection = null;
        try {
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_targetConnectionName);
            if (Connections.getInstance().lock(connection)) {
                resultSet = DBUtil.getInstance((Connection)connection).executeOracleQuery(string, null);
                while (resultSet.next()) {
                    linkedHashMap.put(resultSet.getString(1), resultSet.getString(2));
                    backendDelegatorRaptorTask.checkCanProceed();
                }
            }
        }
        finally {
            DBUtil.closeResultSet(resultSet);
            if (connection != null) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        return linkedHashMap;
    }

    public void writeRedshiftUnloadScript() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "data" + File.separator + "redshift_s3unload.sql"));
        String string = "-- This is a generated SQL Script file 'redshift_s3unload.sql' " + MigrationUtilities.getLineSeparator() + "-- Run this SQL Script in SQLDeveloper Worksheet using AWS user connection to load data from AWS Redshift DB to S3 Bucket." + MigrationUtilities.getLineSeparator() + "-- Please read 'readme.txt' file for more details." + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator();
        printWriter.write(string);
        for (Map.Entry<String, String> entry : this.m_unloadCommandsHash.entrySet()) {
            printWriter.write(entry.getValue() + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        }
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTotalNumberOfTables(String string) throws SQLException, Exception {
        String string2 = null;
        Connection connection = null;
        try {
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_targetConnectionName);
            if (Connections.getInstance().lock(connection)) {
                string2 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("SELECT count(*) FROM sqldev_migrepos.md_tables WHERE type = 'CONVERTED'");
            }
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTotalNumberOfTablesSelected(String string) throws SQLException, Exception {
        String string2 = null;
        Connection connection = null;
        try {
            connection = AWSDataUnloadAndADWCDataLoadTask.getUniqueConnection(this.m_targetConnectionName);
            if (Connections.getInstance().lock(connection)) {
                string2 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string);
            }
        }
        finally {
            if (connection != null) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        return string2;
    }

    public void writeDWCSDataLoadScript() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "data" + File.separator + "adwc_dataload.sql"));
        String string = "execute DBMS_CLOUD.drop_credential(credential_name => '<DWCS_CRED>')".replace("<DWCS_CRED>", "REDSHIFT_ADWC_CREDS");
        String string2 = "execute DBMS_CLOUD.create_credential(credential_name => '<DWCS_CRED>', username => '<aws_access_key>', password => '<aws_secret_key>')".replace("<DWCS_CRED>", "REDSHIFT_ADWC_CREDS").replaceAll("<aws_access_key>", this.m_awsAccessKey).replaceAll("<aws_secret_key>", this.m_awsSecretAccess);
        String string3 = "-- This is a generated SQL Script file 'adwc_dataload.sql' " + MigrationUtilities.getLineSeparator() + "-- Run this SQL Script in SQLDeveloper Worksheet using ADWC admin user to load data into Oracle Database from AWS S3 Bucket." + MigrationUtilities.getLineSeparator() + "-- Please read 'readme.txt' file for more details." + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator() + "-- Drop and create ADWC Credentials." + MigrationUtilities.getLineSeparator();
        printWriter.write(string3);
        printWriter.write(string + ";" + MigrationUtilities.getLineSeparator());
        printWriter.write(string2 + ";" + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        printWriter.write(this.m_utilPkgString + MigrationUtilities.getLineSeparator());
        for (Map.Entry<String, String> entry : this.m_dataLoadCommandsHash.entrySet()) {
            printWriter.write(entry.getValue() + "/" + MigrationUtilities.getLineSeparator());
        }
        printWriter.close();
    }

    public void writeDWCSDataLoadForJobScheduler() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.m_sqlScriptDirectory + File.separator + "data" + File.separator + "adwc_dataload_scheduler.sql"));
        String string = "execute DBMS_CLOUD.drop_credential(credential_name => '<DWCS_CRED>')".replace("<DWCS_CRED>", "REDSHIFT_ADWC_CREDS");
        String string2 = "execute DBMS_CLOUD.create_credential(credential_name => '<DWCS_CRED>', username => '<aws_access_key>', password => '<aws_secret_key>')".replace("<DWCS_CRED>", "REDSHIFT_ADWC_CREDS").replaceAll("<aws_access_key>", this.m_awsAccessKey).replaceAll("<aws_secret_key>", this.m_awsSecretAccess);
        String string3 = "-- This is a generated SQL Script file 'adwc_dataload_scheduler.sql' " + MigrationUtilities.getLineSeparator() + "-- Run this SQL Script in SQLDeveloper Worksheet using ADWC admin user to load data into Oracle Database from AWS S3 Bucket using DBMS_SCHEDULER" + MigrationUtilities.getLineSeparator() + "-- Please read 'readme.txt' file for more details." + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator() + "-- Drop and create ADWC Credentials." + MigrationUtilities.getLineSeparator();
        printWriter.write(string3);
        printWriter.write(string + ";" + MigrationUtilities.getLineSeparator());
        printWriter.write(string2 + ";" + MigrationUtilities.getLineSeparator() + MigrationUtilities.getLineSeparator());
        printWriter.write(this.m_utilPkgString + MigrationUtilities.getLineSeparator());
        for (Map.Entry<String, String> entry : this.m_dataLoadSchedulerCommandsHash.entrySet()) {
            printWriter.write(entry.getValue() + "/" + MigrationUtilities.getLineSeparator());
        }
        printWriter.close();
    }

    public void getUtilPackageString() throws IOException {
        String string;
        Object object = "";
        URL uRL = this.getClass().getClassLoader().getResource("oracle/dbtools/migration/cloud/metadata/repository/plsql/REDSHIFT_MIGRATION_UTILITIES.pls");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        while ((string = bufferedReader.readLine()) != null) {
            object = (String)object + string + MigrationUtilities.getLineSeparator();
        }
        bufferedReader.close();
        this.m_utilPkgString = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWaitForBackendDelegatorRaptorTask(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws Exception {
        BackendDelegatorRaptorTask backendDelegatorRaptorTask2 = backendDelegatorRaptorTask;
        synchronized (backendDelegatorRaptorTask2) {
            while (!this.isDataLoadComplete) {
                ((Object)((Object)backendDelegatorRaptorTask)).wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeBackendDelegatorRaptorTask(BackendDelegatorRaptorTask backendDelegatorRaptorTask) {
        BackendDelegatorRaptorTask backendDelegatorRaptorTask2 = backendDelegatorRaptorTask;
        synchronized (backendDelegatorRaptorTask2) {
            this.isDataLoadComplete = true;
            ((Object)((Object)backendDelegatorRaptorTask)).notifyAll();
        }
    }

    public void traceFlow(String string) {
    }

    private String convertDeployableSchemasToQuotedCommaSeparatedString(String[] stringArray) {
        return Utilities.convertToQuotedCommaSeparatedString(stringArray);
    }

    private String getS3UnloadScripts(String[] stringArray) {
        String string = this.convertDeployableSchemasToQuotedCommaSeparatedString(stringArray);
        String string2 = "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE gen.object_type= 'UNLOAD' and tabl.oracle_name = gen.object_name and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and sche.oracle_name in (<deployable_schemas>) and tabl.type = 'CONVERTED' order by tabl.num_rows asc".replace("<deployable_schemas>", string);
        return string2;
    }

    private String getDataLoadScripts(String[] stringArray) {
        String string = this.convertDeployableSchemasToQuotedCommaSeparatedString(stringArray);
        String string2 = this.m_isUseJobScheduler ? "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'JOB_SCHEDULER' and tabl.oracle_name = gen.object_name and gen.schema_name in (<deployable_schemas>) and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc".replace("<deployable_schemas>", string) : "SELECT gen.schema_name||'.'||gen.object_name as object, gen.sql_script FROM sqldev_migrepos.md_generate gen, sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche  WHERE gen.object_type= 'OCA_COPY_DATA' and tabl.oracle_name = gen.object_name and gen.schema_name in (<deployable_schemas>) and sche.oracle_name = gen.schema_name and sche.schema_name = tabl.schema_name and tabl.type = 'CONVERTED' order by tabl.num_rows asc".replace("<deployable_schemas>", string);
        return string2;
    }

    private String getRowHashScripts(String[] stringArray) {
        String string = this.convertDeployableSchemasToQuotedCommaSeparatedString(stringArray);
        String string2 = "SELECT sche.oracle_name||'.'||tabl.oracle_name, TRIM(TO_CHAR(num_rows, '999,999,999,999,999,999')) FROM sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE tabl.type = 'CONVERTED' and sche.type = 'CONVERTED' and sche.oracle_name in (<deployable_schemas>) order by num_rows asc".replace("<deployable_schemas>", string);
        return string2;
    }

    private String getGetTableSelectedScripts(String[] stringArray) {
        String string = this.convertDeployableSchemasToQuotedCommaSeparatedString(stringArray);
        String string2 = "SELECT count(*) FROM sqldev_migrepos.md_tables tabl, sqldev_migrepos.md_schemas sche WHERE tabl.type = 'CONVERTED' and sche.type = 'CONVERTED' and sche.oracle_name in (<deployable_schemas>) and tabl.schema_name = sche.schema_name".replace("<deployable_schemas>", string);
        return string2;
    }

    public LinkedHashMap<String, String> getDataLoadCommandsHash() {
        return this.m_dataLoadCommandsHashSelected;
    }

    public void setDataLoadCommandsHash(LinkedHashMap<String, String> linkedHashMap) {
        this.m_dataLoadCommandsHashSelected = linkedHashMap;
    }

    public HashMap<String, String> getStatusDataLoadTables() {
        return this.m_statusDataLoadTables;
    }
}

