/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.io.File;
import java.io.PipedInputStream;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.Starter;

public class SimpleProcess
implements Cloneable {
    private SimpleRunProcess simpleRunProcess = new SimpleRunProcess();

    public SimpleProcess() {
    }

    public SimpleProcess(SimpleProcess process) {
        this();
        process.copyTo(this);
    }

    protected Object copyTo(Object o) {
        SimpleProcess other = o != null ? (SimpleProcess)o : new SimpleProcess();
        this.simpleRunProcess.copyTo(other.simpleRunProcess);
        return other;
    }

    public SimpleProcess(String[] cmd) {
        this();
        this.setCommand(cmd);
    }

    public RunProcess getRunProcess() {
        return this.simpleRunProcess;
    }

    public void setCommand(String[] cmd) {
        this.simpleRunProcess.setCommand(cmd);
    }

    public void setEnvironmentParams(String[] environmentParams) {
        SimpleRunProcess.access$202(this.simpleRunProcess, environmentParams);
    }

    public void setUseLogPage(boolean useLogPage) {
        this.simpleRunProcess.useLogPage = useLogPage;
    }

    public void setUseLogPageQuietly(boolean quiet) {
        this.simpleRunProcess.useLogPageQuietly = quiet;
    }

    public void setAllowInput(boolean allowInput) {
        this.simpleRunProcess.allowInput = allowInput;
    }

    public void setWorkingDirectory(File dir) {
        this.simpleRunProcess.dir = dir;
    }

    public void setLabel(String label) {
        this.simpleRunProcess.label = label;
    }

    public void setIcon(Icon icon) {
        this.simpleRunProcess.icon = icon;
    }

    public void setLogPage(LogPage logPageOverride) {
        this.simpleRunProcess.logPageOverride = logPageOverride;
    }

    public void setLogStartDirectory(boolean logStartDirectory) {
        this.simpleRunProcess.logStartDirectory = logStartDirectory;
    }

    public void setLogCommandString(boolean logCommandString) {
        this.simpleRunProcess.logCommandString = logCommandString;
    }

    public void setCommandStringForLog(String commandStringForLog) {
        this.simpleRunProcess.commandStringForLog = commandStringForLog;
    }

    public void setShowStartStatus(boolean showStartStatus) {
        this.simpleRunProcess.showStartStatus = showStartStatus;
    }

    public void setAddToProcessesFolder(boolean addToProcessesFolder) {
        this.simpleRunProcess.addToProcessesFolder = addToProcessesFolder;
    }

    public void setAddToTerminateMenu(boolean addToTerminateMenu) {
        this.simpleRunProcess.addToTerminateMenu = addToTerminateMenu;
    }

    public void setRunProcessListener(RunProcessListener runProcessListener) {
        this.simpleRunProcess.runProcessListener = runProcessListener;
    }

    public void setDoUILater() {
        this.simpleRunProcess.doUILater = true;
    }

    public void setSuppressDirectoryDefault() {
        this.simpleRunProcess.suppressDirectoryDefault = true;
    }

    public PipedInputStream duplicateOutputStream() {
        return this.simpleRunProcess.duplicateOutputStream();
    }

    public PipedInputStream duplicateErrorStream() {
        return this.simpleRunProcess.duplicateErrorStream();
    }

    public void exec() {
        this.simpleRunProcess.start();
    }

    public int execAndWait() {
        this.simpleRunProcess.execAndWait = true;
        if (!this.simpleRunProcess.doUILater && SwingUtilities.isEventDispatchThread()) {
            this.simpleRunProcess.doUILater = true;
        }
        this.simpleRunProcess.start();
        return this.simpleRunProcess.getExitCode();
    }

    public Object clone() {
        return new SimpleProcess(this);
    }

    public Exception getExecException() {
        return this.simpleRunProcess.starter.getStartException();
    }

    final class SimpleRunProcess
    extends RunProcess {
        private String[] cmd;
        private String[] environmentParams;
        private File dir;
        private String label;
        private Icon icon;
        private String commandStringForLog;
        private boolean execAndWait;
        private boolean doUILater;
        private boolean suppressDirectoryDefault;

        private SimpleRunProcess() {
            super(new Context());
            this.logStartDirectory = true;
            this.logCommandString = true;
            this.showStartStatus = true;
            this.addToProcessesFolder = true;
            this.addToTerminateMenu = true;
        }

        @Override
        protected Object copyTo(Object o) {
            SimpleRunProcess other = o != null ? (SimpleRunProcess)o : new SimpleRunProcess();
            super.copyTo(other);
            other.cmd = this.cmd;
            other.environmentParams = this.environmentParams;
            other.dir = this.dir;
            other.label = this.label;
            other.icon = this.icon;
            other.commandStringForLog = this.commandStringForLog;
            other.execAndWait = this.execAndWait;
            other.doUILater = this.doUILater;
            other.suppressDirectoryDefault = this.suppressDirectoryDefault;
            return other;
        }

        private void setCommand(String[] cmd) {
            this.cmd = cmd;
            this.label = cmd != null && cmd.length > 0 ? cmd[0] : "";
        }

        @Override
        public String getProcessLabelPrefix() {
            return this.label;
        }

        @Override
        public String getShortLabel() {
            return this.label;
        }

        @Override
        public String getShortLabelWithPrefix() {
            return this.label;
        }

        @Override
        public String getLongLabel() {
            return this.label;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        protected void determineTargetAndStarter(Class starterFactorySubClass) {
            if (this.starter != null) {
                return;
            }
            this.target = null;
            this.starter = this.getStarterForTarget(this.target);
        }

        protected Starter getStarterForTarget(Node target) {
            return new Starter(this);
        }

        @Override
        public String[] getStartEnvironmentParams() {
            return this.environmentParams;
        }

        @Override
        public File getStartDirectory() {
            return this.dir;
        }

        @Override
        public String[] getStartCommand() {
            return this.cmd;
        }

        @Override
        public String fixCommandStringForLog(String[] command) {
            if (this.commandStringForLog != null) {
                return this.commandStringForLog;
            }
            return super.fixCommandStringForLog(command);
        }

        @Override
        protected boolean mustPrepareToStart() {
            boolean mustPrepare = super.mustPrepareToStart();
            if (mustPrepare && this.execAndWait) {
                throw new UnsupportedOperationException("SimpleProcess.execAndWait: mustPrepareToStart is true");
            }
            return mustPrepare;
        }

        @Override
        public boolean doUILater() {
            return this.doUILater;
        }

        @Override
        public boolean suppressDirectoryDefault() {
            return this.suppressDirectoryDefault;
        }

        private int getExitCode() {
            if (this.starter != null) {
                return this.starter.waitForProcess();
            }
            return -1;
        }

        static /* synthetic */ String[] access$202(SimpleRunProcess x0, String[] x1) {
            x0.environmentParams = x1;
            return x1;
        }
    }
}

