/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;

public class RunnableItem {
    private static String CMD_PREFIX = "RunnableItem";
    private static int countRunnableCommands = 0;
    private RunProcess runProcess;
    private Context context;
    private Node node;
    private AbstractStarterFactory abstractStarterFactory;
    private Object cookie;
    private Displayable displayable;
    private IdeAction action;

    RunnableItem(RunProcess runProcess, Context context, Node node, AbstractStarterFactory abstractStarterFactory, Object cookie) {
        this.runProcess = runProcess;
        this.context = context;
        this.node = node;
        this.abstractStarterFactory = abstractStarterFactory;
        this.cookie = cookie;
    }

    public IdeAction getAction() {
        if (this.action == null) {
            int cmdId = Ide.findOrCreateCmdID((String)(CMD_PREFIX + ++countRunnableCommands));
            if (this.displayable == null) {
                this.displayable = this.abstractStarterFactory.getDisplayable(this.runProcess, this.context, this.node, this.cookie);
            }
            String name = this.displayable.getShortLabel();
            Icon icon = this.displayable.getIcon();
            this.action = IdeAction.get((int)cmdId, null, (String)name, (String)null, null, (Icon)icon, (Object)this, (boolean)true);
            this.action.putValue("Name", (Object)name);
            this.action.putValue("SmallIcon", (Object)icon);
            this.action.putValue("UserData", (Object)this);
        }
        return this.action;
    }

    public void start() {
        this.runProcess.start(this.node, this.abstractStarterFactory, this.cookie);
    }

    public void clear() {
        this.runProcess = null;
        this.context = null;
        this.node = null;
        this.abstractStarterFactory = null;
        this.cookie = null;
        this.displayable = null;
        if (this.action != null) {
            this.action.putValue("UserData", null);
            this.action = null;
        }
    }

    public static void reset() {
        countRunnableCommands = 0;
    }
}

