/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util.deferred;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.util.deferred.Thunk;

public class THC {
    private final Map<Class<?>, Object> container = new HashMap();

    public <T> void put(Class<T> key, final DeriveValue<T> value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.container.put(key, new Thunk<T>(){

            @Override
            protected T compute() {
                return value.get(THC.this);
            }
        });
    }

    public <T> void put(Class<T> key, T value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.container.put(key, value);
    }

    public <T> T get(Class<T> key) {
        Object object = this.container.get(key);
        if (object instanceof Thunk) {
            return ((Thunk)object).get();
        }
        return key.cast(object);
    }

    public <Interface> Interface as(final Class<Interface> type) {
        assert (type.isInterface() && this.verifyInterface(type)) : "Interface should consist entirely of zero parameter methods";
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() != type) {
                    throw new NoSuchMethodException("Not on this proxy");
                }
                return THC.this.get(method.getReturnType());
            }
        }));
    }

    private boolean verifyInterface(Class type) {
        for (Method method : type.getDeclaredMethods()) {
            if (method.getParameterTypes().length > 0) {
                return false;
            }
            if (method.getReturnType() != Void.class) continue;
            return false;
        }
        return true;
    }

    public static interface DeriveValue<T> {
        public T get(THC var1);
    }
}

