/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.File;
import java.io.IOException;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class PlatformUtils {
    @CodeSharingSafe(value="StaticField")
    private static final String _osName = PlatformUtils.initOsName();
    @CodeSharingSafe(value="StaticField")
    private static final String _osVersion = PlatformUtils.initOsVersion();
    public static final int OS_UNKNOWN = 0;
    public static final int OS_LINUX = 1;
    public static final int OS_MAC = 2;
    public static final int OS_MAC_PANTHER = 3;
    public static final int OS_MAC_TIGER = 4;
    public static final int OS_WINDOWS = 5;
    public static final int OS_WINDOWS_NT = 6;
    public static final int OS_WINDOWS_2K = 7;
    public static final int OS_WINDOWS_XP = 8;
    private static final int OS_WINDOWS_VISTA = 9;
    private static final int OS_WINDOWS_7 = 10;
    private static final int OS_WINDOWS_8 = 11;
    @CodeSharingSafe(value="StaticField")
    private static final int _platform = PlatformUtils.initPlatform();
    @CodeSharingSafe(value="StaticField")
    private static final boolean caseSensitiveFileSystem = PlatformUtils.initCaseSensitiveFileSystem();

    private static String initOsName() {
        String name = System.getProperty("os.name");
        return name == null ? "" : name;
    }

    private static String initOsVersion() {
        String _osVersion = System.getProperty("os.version");
        return _osVersion == null ? "" : _osVersion;
    }

    private static int initPlatform() {
        String lower = _osName.toLowerCase();
        if (lower.startsWith("linux")) {
            return 1;
        }
        if (lower.startsWith("mac os x")) {
            if (_osVersion.startsWith("10.4")) {
                return 4;
            }
            if (_osVersion.startsWith("10.3")) {
                return 3;
            }
            return 2;
        }
        if (lower.startsWith("windows")) {
            if (lower.startsWith("windows xp")) {
                return 8;
            }
            if (lower.startsWith("windows 2000")) {
                return 7;
            }
            if (lower.startsWith("windows nt")) {
                return 6;
            }
            if (lower.startsWith("windows vista")) {
                return 9;
            }
            if (lower.startsWith("windows 7")) {
                return 10;
            }
            if (lower.startsWith("windows 8")) {
                return 11;
            }
            return 5;
        }
        return 0;
    }

    private static boolean initCaseSensitiveFileSystem() {
        try {
            File tempFile = File.createTempFile("ABC", null);
            tempFile.deleteOnExit();
            return !new File(tempFile.getPath().toLowerCase()).exists();
        }
        catch (IOException ioe) {
            return !new File("A").equals(new File("a"));
        }
    }

    private PlatformUtils() {
    }

    public static String osName() {
        return _osName;
    }

    public static String osVersion() {
        return _osVersion;
    }

    public static int getPlatform() {
        return _platform;
    }

    public static boolean isCaseSensitiveFileSystem() {
        return caseSensitiveFileSystem;
    }

    public static boolean isKnown() {
        return _platform != 0;
    }

    public static boolean isLinux() {
        return _platform == 1;
    }

    public static boolean isMac() {
        return _platform >= 2 && _platform < 5;
    }

    public static boolean isMacPanther() {
        return _platform == 3;
    }

    public static boolean isMacTiger() {
        return _platform == 4;
    }

    public static boolean isWindows() {
        return _platform >= 5;
    }

    public static boolean isWindowsNT() {
        return _platform == 6;
    }

    public static boolean isWindows2K() {
        return _platform == 7;
    }

    public static boolean isWindowsXP() {
        return _platform == 8;
    }

    public static boolean isWindowsVista() {
        return _platform == 9;
    }

    public static boolean isWindows7() {
        return _platform == 10;
    }

    public static boolean isWindows8() {
        return _platform == 11;
    }

    public static boolean isAtLeastMacPanther() {
        return _platform >= 3 && _platform < 5;
    }

    public static boolean isAtLeastMacTiger() {
        return _platform >= 4 && _platform < 5;
    }

    public static boolean isAtLeastWindowsNT() {
        return _platform >= 6;
    }

    public static boolean isAtLeastWindows2K() {
        return _platform >= 7;
    }

    public static boolean isAtLeastWindowsXP() {
        return _platform >= 8;
    }

    public static boolean isAtLeastWindowsVista() {
        return _platform >= 9;
    }

    public static boolean isAtLeastWindows7() {
        return _platform >= 10;
    }

    public static boolean isAtLeastWindows8() {
        return _platform >= 11;
    }
}

