/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.CollectionEvent;
import oracle.javatools.util.CollectionListener;
import oracle.javatools.util.ListenableCollection;

public class ListenableHashSet<E>
extends HashSet<E>
implements ListenableCollection<E> {
    private final List<CollectionListener<E>> listeners = this.createListenerList();

    public ListenableHashSet() {
    }

    public ListenableHashSet(Collection<? extends E> c) {
        super(c);
    }

    public ListenableHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ListenableHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void addListener(CollectionListener<E> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange(CollectionEvent.Type type, E element, int index) {
        if (this.listeners != null) {
            CollectionEvent<E> event = new CollectionEvent<E>(this, type, element, index);
            for (CollectionListener<E> l : this.listeners) {
                l.collectionChanged(event);
            }
        }
    }

    protected List<CollectionListener<E>> createListenerList() {
        return new CopyOnWriteArrayList<CollectionListener<E>>();
    }

    @Override
    public boolean add(E e) {
        boolean added = super.add(e);
        if (added) {
            this.fireChange(CollectionEvent.Type.ADDITION, e, -1);
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = false;
        for (E e : c) {
            added |= this.add(e);
        }
        return added;
    }

    @Override
    public void clear() {
        Object[] objs = this.toArray();
        super.clear();
        for (Object obj : objs) {
            this.fireChange(CollectionEvent.Type.REMOVAL, obj, -1);
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean contained = super.remove(o);
        if (contained) {
            this.fireChange(CollectionEvent.Type.REMOVAL, o, -1);
        }
        return contained;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }
}

