/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.patch.PatchAssistance;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchModel;

public class PatchFormat {
    private static final String NO_NL_AT_EOF_MARKER = "\\ No newline at end of file";
    private String _charsetName;

    public void setEncoding(String charsetName) {
        this._charsetName = charsetName;
    }

    public String getEncoding() {
        return this._charsetName;
    }

    public byte[] formatByte(PatchModel model) {
        OutputStreamWriter osw;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            osw = this._charsetName != null ? new OutputStreamWriter((OutputStream)baos, this._charsetName) : new OutputStreamWriter(baos);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return new byte[0];
        }
        BufferedWriter bw = new BufferedWriter(osw);
        try {
            PatchEntry[] entries = model.getEntries();
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].getFromFile() != null) {
                    bw.write("--- " + this.formatEntryHeaderLine(entries[i].getFromFile(), entries[i].getFromFileModificationTime(), entries[i].getFromFileRevision()));
                    bw.newLine();
                }
                if (entries[i].getToFile() != null) {
                    bw.write("+++ " + this.formatEntryHeaderLine(entries[i].getToFile(), entries[i].getToFileModificationTime(), entries[i].getToFileRevision()));
                    bw.newLine();
                }
                PatchHunk[] hunks = entries[i].getHunks();
                for (int j = 0; j < hunks.length; ++j) {
                    bw.write(this.formatHunkRangeLine(hunks[j]));
                    bw.newLine();
                    PatchHunkLine[] hunkLines = hunks[j].getLines();
                    for (int k = 0; k < hunkLines.length; ++k) {
                        int indicator = hunkLines[k].getIndicator();
                        if (indicator == 2) {
                            bw.write(43);
                        }
                        if (indicator == 3) {
                            bw.write(45);
                        }
                        if (indicator == 1) {
                            bw.write(32);
                        }
                        bw.write(hunkLines[k].getLineData());
                        bw.newLine();
                        if (!hunkLines[k].isNoNewlineAtEOF()) continue;
                        bw.write(NO_NL_AT_EOF_MARKER);
                        bw.newLine();
                    }
                }
                bw.flush();
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return new byte[0];
        }
    }

    public String format(PatchModel model) {
        try {
            return this._charsetName != null ? new String(this.formatByte(model), this._charsetName) : new String(this.formatByte(model));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public PatchModel parse(String source, PatchAssistance assist) throws ParseException {
        return this.parse(source.getBytes(), false, assist);
    }

    public PatchModel parse(byte[] source, boolean noFile, PatchAssistance assist) throws ParseException {
        InputStreamReader isr;
        String toFile = "";
        String fromFile = "";
        PatchModel model = new PatchModel();
        try {
            isr = this._charsetName != null ? new InputStreamReader((InputStream)new ByteArrayInputStream(source), this._charsetName) : new InputStreamReader(new ByteArrayInputStream(source));
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return model;
        }
        BufferedReader br = new BufferedReader(isr);
        PatchEntry entry = null;
        PatchHunk hunk = null;
        PatchHunkLine hunkLine = null;
        Pattern pattern2 = Pattern.compile("@@ -([^ ]+) \\+([^ ]+) @@.*");
        while (true) {
            String line = null;
            try {
                line = br.readLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (line == null) break;
            assist.process(line);
            if (assist.fromFile() != null && !assist.fromFile().equals(fromFile) || assist.isNewEntry()) {
                entry = new PatchEntry();
                model.addEntry(entry);
                hunk = null;
                entry.setFromFile(assist.fromFile());
                entry.setFromFileModificationTime(assist.getFromModificationTime());
                entry.setFromFileRevision(assist.getFromRevision());
                fromFile = assist.fromFile();
                continue;
            }
            if (assist.toFile() != null && !assist.toFile().equals(toFile)) {
                if (entry == null) continue;
                entry.setToFile(assist.toFile());
                entry.setToFileModificationTime(assist.getToModificationTime());
                entry.setToFileRevision(assist.getToRevision());
                toFile = assist.toFile();
                if (!assist.isNew() && !assist.isCopy()) continue;
                assist.fixUpFilenames();
                entry.setFromFile(assist.fromFile());
                entry.setToFile(assist.toFile());
                entry.setNewFile(assist.isNew());
                fromFile = entry.getFromFile();
                toFile = entry.getToFile();
                continue;
            }
            if (entry == null && noFile) {
                entry = new PatchEntry();
                hunk = null;
                model.addEntry(entry);
            }
            if (entry == null) continue;
            Matcher matcher = pattern2.matcher(line);
            if (matcher.matches()) {
                hunk = new PatchHunk();
                entry.addHunk(hunk);
                try {
                    String s = matcher.group(1);
                    int i = s.indexOf(44);
                    hunk.setFromFileLineNumber(this.parseRangeLineNumber(s, i));
                    hunk.setFromFileLineCount(this.parseRangeLineCount(s, i));
                    s = matcher.group(2);
                    i = s.indexOf(44);
                    hunk.setToFileLineNumber(this.parseRangeLineNumber(s, i));
                    hunk.setToFileLineCount(this.parseRangeLineCount(s, i));
                }
                catch (NumberFormatException nfe) {
                    throw new PatchParseException("contains bad line number or count: \"" + line + "\"");
                }
            }
            if (line.length() == 0 || hunk == null) continue;
            char initialChar = line.charAt(0);
            if (line.startsWith(NO_NL_AT_EOF_MARKER) && hunkLine != null) {
                hunkLine.setNoNewlineAtEOF(true);
                continue;
            }
            hunkLine = null;
            if (initialChar == ' ') {
                hunkLine = new PatchHunkLine(1);
            }
            if (initialChar == '+') {
                hunkLine = new PatchHunkLine(2);
            }
            if (initialChar == '-') {
                hunkLine = new PatchHunkLine(3);
            }
            if (hunkLine == null) continue;
            hunkLine.setLineData(line.substring(1));
            hunk.addLine(hunkLine);
        }
        if (model.getEntries().length <= 0) {
            throw new PatchParseException("does not contain any entry information");
        }
        PatchEntry[] entries = model.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (noFile || entries[i].getFromFile() != null || entries[i].getToFile() != null) continue;
            throw new PatchParseException("contains a null to/from file entry");
        }
        return model;
    }

    private String formatEntryHeaderLine(String fileName, Date modTime, String revision) {
        StringBuffer headerLineBuffer = new StringBuffer();
        if (fileName != null) {
            headerLineBuffer.append(fileName);
        } else {
            headerLineBuffer.append("/dev/null");
        }
        if (modTime != null) {
            headerLineBuffer.append('\t');
            headerLineBuffer.append(new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", PatchAssistance.DIFF_DATE_LOCALE).format(modTime));
        }
        if (revision != null) {
            headerLineBuffer.append('\t');
            headerLineBuffer.append(revision);
        }
        return headerLineBuffer.toString();
    }

    private String formatHunkRangeLine(PatchHunk hunk) {
        StringBuffer rangeLineBuffer = new StringBuffer();
        rangeLineBuffer.append("@@ -");
        rangeLineBuffer.append(hunk.getFromFileLineNumber());
        if (hunk.getFromFileLineCount() != 1) {
            rangeLineBuffer.append(',');
            rangeLineBuffer.append(hunk.getFromFileLineCount());
        }
        rangeLineBuffer.append(" +");
        rangeLineBuffer.append(hunk.getToFileLineNumber());
        if (hunk.getToFileLineCount() != 1) {
            rangeLineBuffer.append(',');
            rangeLineBuffer.append(hunk.getToFileLineCount());
        }
        rangeLineBuffer.append(" @@");
        return rangeLineBuffer.toString();
    }

    private int parseRangeLineNumber(String range, int i) {
        return Math.max(0, Integer.parseInt(i < 0 ? range : range.substring(0, i)));
    }

    private int parseRangeLineCount(String range, int i) {
        int lineCount = -1;
        if (i > 0) {
            lineCount = Integer.parseInt(range.substring(i + 1));
        }
        return lineCount < 0 ? 1 : lineCount;
    }

    private class PatchParseException
    extends ParseException {
        PatchParseException(String message) {
            super("Unparseable patch: " + message, 0);
        }
    }
}

