/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import java.util.Iterator;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.PlsqlTokens;
import oracle.javatools.parser.plsql.old.symbol.CommonRoot;
import oracle.javatools.parser.plsql.old.symbol.ErrorSymbol;
import oracle.javatools.parser.util.ArrayListHeap;

public class PlsqlSymbol
extends ArrayListHeap
implements PlsqlSyntaxCodes,
PlsqlTokens {
    PlsqlSymbol parent = null;
    int code = 0;
    int startOffset = -1;
    int endOffset = -1;
    int dataValue = 0;
    public static final int SYNTAX_EOF = 0;
    public static final int SYNTAX_ROOT = 10;
    public static final int SYNTAX_ERROR = 1;
    static final String ERR_READONLY_AFTER_PARSE = "Parse structure is read-only after parse is finished";

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getCode() {
        return this.code;
    }

    public int getDataValue() {
        return this.dataValue;
    }

    PlsqlSymbol(int code) {
        this.code = code;
    }

    public PlsqlSymbol getParent() {
        return this.parent;
    }

    void doneParsing() {
    }

    void reportSyntaxError(String msg) {
        PlsqlSymbol findRoot = this.parent;
        while (findRoot.parent != null) {
            findRoot = findRoot.parent;
        }
        CommonRoot root = (CommonRoot)findRoot;
        ErrorSymbol error = new ErrorSymbol(msg);
        error.startOffset = this.startOffset;
        error.endOffset = this.endOffset;
        root.addError(error);
    }

    void error(String msg) {
        String codeString = PlsqlSyntaxRecognizer.codeToString(this.code);
        String errMsg = "PlsqlSymbol error: (" + codeString + ") - " + msg;
        System.err.println(errMsg);
        throw new RuntimeException(errMsg);
    }

    void internalError(String msg) {
        String codeString = PlsqlSyntaxRecognizer.codeToString(this.code);
        String errMsg = "PlsqlSymbol internal error: (" + codeString + ") - " + msg;
        System.err.println(errMsg);
        throw new RuntimeException(errMsg);
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public boolean isLeafNode() {
        return true;
    }

    public Iterator getChildren() {
        return null;
    }
}

