/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

public final class LiteralExpr
extends Expr
implements SourceLiteralExpression {
    public LexerLiteral literal;
    public String literalString = "";

    @Override
    public int getTokenValue() {
        if (this.literal != null) {
            return this.literal.literalToken;
        }
        return 8;
    }

    @Override
    public LexerLiteral getLiteral() {
        return this.literal;
    }

    @Override
    public Object getConstantValue() {
        if (this.literal != null) {
            return this.literal.getConstantValue();
        }
        return null;
    }

    @Override
    public String getText() {
        return this.literalString;
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        LiteralExpr sym = (LiteralExpr)super.cloneSelf(targetFile);
        sym.literalString = this.literalString;
        if (this.literal != null) {
            sym.literal = LexerLiteral.copyConstant(this.literal);
        }
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        Object constantValue = this.getConstantValue();
        if (constantValue != null) {
            buffer.append(' ');
            buffer.append(constantValue.toString());
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

