/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.doc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocInlineTagSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocSym;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocInlineTag;

public class DocDescriptionSym
extends DocSym
implements SourceDocDescription {
    @CodeSharingSafe(value="StaticField")
    static final DocDescriptionSym[] EMPTY_ARRAY = new DocDescriptionSym[0];

    @Override
    public boolean isBlank() {
        Iterator<SourceElement> i = this.getChildren().iterator();
        while (i.hasNext()) {
            if (((SourceDocElement)i.next()).isBlank()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<SourceDocInlineTag> findTags(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name null or empty");
        }
        ArrayList<SourceDocInlineTag> list = new ArrayList<SourceDocInlineTag>();
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!name.equals(docInlineTagSym.getName())) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    public Collection<SourceDocInlineTag> findReferenceTags() {
        ArrayList<SourceDocInlineTag> list = new ArrayList<SourceDocInlineTag>();
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!docInlineTagSym.isReference()) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    public Collection<SourceDocInlineTag> findReferenceTags(String referenceName) {
        if (referenceName == null || referenceName.length() == 0) {
            throw new IllegalArgumentException("referenceName null or empty");
        }
        ArrayList<SourceDocInlineTag> list = new ArrayList<SourceDocInlineTag>();
        for (DocInlineTagSym docInlineTagSym : this.getInlineTags()) {
            if (!docInlineTagSym.isReference(referenceName)) continue;
            list.add(docInlineTagSym);
        }
        return list;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 85: 
            case 88: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    void appendDocText(StringBuilder buffer) {
        int bufferLength = buffer.length();
        if (bufferLength > 0 && buffer.charAt(bufferLength - 1) != ' ') {
            buffer.append(' ');
        }
        super.appendDocText(buffer);
    }
}

