/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.SourceLexicalElement;

public class LexicalSym
extends Sym
implements SourceLexicalElement {
    public short tokenValue;
    public String tokenText = "";

    @Override
    public int getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public String getText() {
        Object binding = this.getInternalBinding(1);
        if (binding != null) {
            return binding.toString();
        }
        return this.tokenText;
    }

    @Override
    public void setText(String text) {
        this.setTextImpl(text);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        LexicalSym sym = (LexicalSym)super.cloneSelf(targetFile);
        sym.tokenValue = this.tokenValue;
        sym.tokenText = this.tokenText;
        return sym;
    }

    @Override
    protected Sym cloneSelfImpl(FileSym targetFile) {
        LexicalSym.notImplementedYet();
        return null;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        if (this.tokenText == null) {
            return;
        }
        int length = this.tokenText.length();
        buffer.append(' ');
        buffer.append('\"');
        if (length <= 8) {
            buffer.append(this.tokenText);
        } else {
            buffer.append(this.tokenText.substring(0, 8) + "...");
        }
        buffer.append('\"');
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        out.print(this.getText());
    }
}

