/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.BufferedEmitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

final class LineWrappingEmitter
extends BufferedEmitter {
    int resetCounter = 0;
    private int zeroIndex = 0;
    private List<Integer> wrapColumns = new ArrayList<Integer>();
    private List<Integer> columnAdjusts = new ArrayList<Integer>();
    private short wrapLineWidth = (short)76;
    private List<WrapBoundary> wrapBoundaries = new ArrayList<WrapBoundary>();

    LineWrappingEmitter() {
    }

    @Override
    void init(Sym s) {
        super.init(s);
        int width = this.formatter.preferences.getInt(75);
        this.wrapLineWidth = LineWrappingEmitter.int2unsignedShort(width);
        this.wrapColumns.clear();
        this.columnAdjusts.clear();
        this.resetCounter = 0;
        this.zeroIndex = 0;
        this.clearWrapBoundaries();
    }

    boolean isWrapCapable() {
        return true;
    }

    @Override
    int getColumn() {
        int length = this.buffer.length();
        int totalAdjust = 0;
        for (int x = 0; x < this.wrapColumns.size() && this.adjust(this.wrapColumns.get(x)) <= length; ++x) {
            totalAdjust += this.columnAdjusts.get(x).intValue();
        }
        return length - this.zeroIndex - totalAdjust;
    }

    @Override
    int getColumnStamp() {
        return this.resetCounter;
    }

    int getColumn_forIndentationUse() {
        return this.unadjusted2indent(this.getColumn());
    }

    private void beforeNewline() {
        this.performLineWrapping();
    }

    private void afterNewline() {
        ++this.resetCounter;
        this.wrapColumns.clear();
        this.columnAdjusts.clear();
        this.zeroIndex = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        this.clearWrapBoundaries();
    }

    @Override
    final void clearWrapBoundaries() {
        this.wrapBoundaries.clear();
    }

    private void clearHigherWrapBoundaries(int height) {
        for (int x = this.wrapBoundaries.size() - 1; x >= 0; --x) {
            WrapBoundary wrapBoundary = this.wrapBoundaries.get(x);
            if (wrapBoundary.stackHeight <= height) continue;
            this.wrapBoundaries.remove(x);
        }
    }

    private int adjust(int unadjusted) {
        int column = unadjusted;
        for (int i = 0; i < this.wrapColumns.size() && this.wrapColumns.get(i) <= unadjusted; ++i) {
            column += this.columnAdjusts.get(i).intValue();
        }
        return column;
    }

    private int unadjusted2indent(int unadjusted) {
        char ch;
        int distance;
        int adjustedColumn = this.adjust(unadjusted);
        int adjustedIndex = adjustedColumn + this.zeroIndex;
        int lastNewline = LineWrappingEmitter.lastIndexOfNewline(this.buffer, adjustedIndex);
        int firstChar = lastNewline + 1;
        int indent = distance = adjustedIndex - firstChar;
        if (this.buffer.length() <= firstChar) {
            return indent;
        }
        for (int i = 0; i < distance && (ch = this.buffer.charAt(lastNewline + 1 + i)) == '\t'; ++i) {
            indent += this.tabSize - 1;
        }
        return indent;
    }

    @Override
    void markWrapBoundary(int height) {
        int a;
        int n = a = this.wrapBoundaries.size() > 0 ? this.wrapBoundaries.get(0).stackHeight : -1;
        if (a >= 0 && this.willLineWrap()) {
            this.performLineWrapping();
        }
        this.clearHigherWrapBoundaries(height);
        WrapBoundary wrapBoundary = new WrapBoundary();
        wrapBoundary.column = this.getColumn();
        wrapBoundary.align = this.formatter.getIndent();
        wrapBoundary.stackHeight = height;
        for (int x = 0; x < this.wrapBoundaries.size(); ++x) {
            if (this.wrapBoundaries.get(x).stackHeight != height) continue;
            this.wrapBoundaries.remove(x);
            break;
        }
        this.wrapBoundaries.add(wrapBoundary);
        Collections.sort(this.wrapBoundaries, new Comparator<WrapBoundary>(){

            @Override
            public int compare(WrapBoundary o1, WrapBoundary o2) {
                return o1.stackHeight - o2.stackHeight;
            }
        });
    }

    boolean willLineWrap() {
        if (this.wrapBoundaries.isEmpty()) {
            return false;
        }
        int lineZero = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
        int lineColumn = this.buffer.length() - lineZero;
        return this.wrapLineWidth < lineColumn;
    }

    @Override
    void forceLineWrapping() {
        this.performLineWrappingImpl(this.buffer.length(), this.formatter.getIndent());
    }

    @Override
    void performLineWrapping() {
        while (!this.wrapBoundaries.isEmpty()) {
            int adjustedBoundary;
            int target;
            int charCount;
            int lineZero = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
            int lineLength = charCount = this.buffer.length() - lineZero;
            for (int i = 0; i < charCount; ++i) {
                char ch = this.buffer.charAt(lineZero + i);
                if (ch != '\t') continue;
                lineLength += this.tabSize - 1;
            }
            if (this.wrapLineWidth >= lineLength) break;
            WrapBoundary wrapBoundary = this.wrapBoundaries.remove(0);
            int length = this.buffer.length();
            for (target = adjustedBoundary = this.adjust(wrapBoundary.column) + this.zeroIndex; target < length && Character.isWhitespace(this.buffer.charAt(target)); ++target) {
            }
            if (target > length) continue;
            this.performLineWrappingImpl(target, wrapBoundary.align);
        }
    }

    private void performLineWrappingImpl(int target, int indentValue) {
        int insertIndex;
        int adjustedIndentValue = this.adjust(indentValue);
        int adjustedTarget = adjustedIndentValue + this.zeroIndex;
        if (adjustedTarget >= target) {
            return;
        }
        String saved = this.buffer.substring(target);
        this.buffer.setLength(target);
        int wrapColumn = this.getColumn();
        super.emit('\n');
        this.emitIndent(indentValue);
        int thisAdjust = this.buffer.length() - target;
        if (saved.length() > 0) {
            super.emit(saved);
        }
        for (insertIndex = 0; insertIndex < this.wrapColumns.size() && this.wrapColumns.get(insertIndex) <= wrapColumn; ++insertIndex) {
        }
        this.wrapColumns.add(insertIndex, wrapColumn);
        this.columnAdjusts.add(insertIndex, thisAdjust);
    }

    @Override
    int getLastIndent() {
        int count = 0;
        for (int lf = this.buffer.lastIndexOf("\n") + 1; lf < this.buffer.length() && Character.isWhitespace(this.buffer.charAt(lf)); ++lf) {
            ++count;
        }
        return count;
    }

    @Override
    final boolean hasWrapBoundariesBefore(int stackHeight) {
        for (WrapBoundary wrapBoundary : this.wrapBoundaries) {
            if (wrapBoundary.stackHeight > stackHeight) continue;
            return true;
        }
        return false;
    }

    @Override
    void emitIndent(int column) {
        int indent = this.unadjusted2indent(column);
        this.emitIndentImpl(indent, this.formatter.flag_docindent);
    }

    @Override
    void emit(String s) {
        boolean newline;
        boolean bl = newline = s.indexOf(10) >= 0;
        if (newline) {
            this.beforeNewline();
        }
        super.emit(s);
        if (newline) {
            this.afterNewline();
        }
    }

    @Override
    void emit(char ch) {
        boolean newline;
        boolean bl = newline = ch == '\n';
        if (newline) {
            this.beforeNewline();
        }
        super.emit(ch);
        if (newline) {
            this.afterNewline();
        }
    }

    @Override
    void insert(int offset, char ch) {
        super.insert(offset, ch);
        this.zeroIndex = LineWrappingEmitter.lastIndexOfNewline(this.buffer) + 1;
    }

    public static int lastIndexOfNewline(StringBuffer b) {
        int lf = b.lastIndexOf("\n");
        if (lf >= 0) {
            return lf;
        }
        return b.lastIndexOf("\r");
    }

    public static int lastIndexOfNewline(StringBuffer b, int fromIndex) {
        int lf = b.lastIndexOf("\n", fromIndex);
        if (lf >= 0) {
            return lf;
        }
        int cr = b.lastIndexOf("\r", fromIndex);
        if (cr >= 0) {
            if (cr + 1 < b.length() && b.charAt(cr + 1) == '\n') {
                return LineWrappingEmitter.lastIndexOfNewline(b, cr - 1);
            }
            return cr;
        }
        return -1;
    }

    private static class WrapBoundary {
        private int column = -1;
        private int align = -1;
        private int stackHeight = -1;

        private WrapBoundary() {
        }
    }
}

