/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

abstract class BufferedEmitter
extends Emitter {
    private static final String eolSeparator = System.getProperty("line.separator");
    protected final StringBuffer buffer = new StringBuffer();
    protected byte tabSize = (byte)4;
    protected boolean replaceWithTabs = false;
    private int newlinesEmitted;

    BufferedEmitter() {
    }

    public final void clear() {
        this.buffer.setLength(0);
    }

    @Override
    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String text = this.getBuffer().toString();
        textBuffer.insert(0, text.toCharArray());
        return textBuffer;
    }

    final StringBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final String toString() {
        return this.getBuffer().toString();
    }

    @Override
    void init(Sym s) {
        this.buffer.setLength(0);
        int size = this.formatter.preferences.getInt(2);
        this.tabSize = BufferedEmitter.int2unsignedByte(size);
        this.replaceWithTabs = this.formatter.preferences.getBoolean(1);
    }

    @Override
    void fini(Sym s) {
        int length = this.buffer.length();
        int writeIndex = 0;
        boolean foundTrailing = false;
        for (int readIndex = 1; readIndex < length; ++readIndex) {
            char ch = this.buffer.charAt(readIndex);
            if (ch == '\n' || ch == '\r') {
                while (this.buffer.charAt(writeIndex) == ' ') {
                    foundTrailing = true;
                    if (--writeIndex >= 0) continue;
                }
            }
            ++writeIndex;
            if (!foundTrailing) continue;
            this.buffer.setCharAt(writeIndex, ch);
        }
        if (foundTrailing) {
            this.buffer.setLength(writeIndex + 1);
        }
    }

    private void emitImpl(String s) {
        this.buffer.append(s);
        for (int index = 0; index >= 0 && (index = s.indexOf(10, index)) >= 0; ++index) {
            ++this.newlinesEmitted;
        }
    }

    final void emitIndentImpl(int spaces, boolean docindent) {
        if (this.replaceWithTabs && this.tabSize > 0) {
            while (spaces >= this.tabSize) {
                this.buffer.append('\t');
                spaces -= this.tabSize;
            }
        }
        for (int i = 0; i < spaces; ++i) {
            this.buffer.append(' ');
        }
        if (docindent) {
            this.buffer.append(" * ");
        }
    }

    @Override
    abstract void emitIndent(int var1);

    @Override
    void emit(String s) {
        this.emitImpl(s);
    }

    @Override
    void emit(short tk) {
        this.emitImpl(BufferedEmitter.tk2text(tk));
    }

    @Override
    void emit(char ch) {
        if (ch == '\n') {
            this.buffer.append(eolSeparator);
            ++this.newlinesEmitted;
        } else {
            this.buffer.append(ch);
        }
    }

    @Override
    void insert(int offset, char ch) {
        if (ch == '\n') {
            ++this.newlinesEmitted;
        }
        this.buffer.insert(offset, ch);
    }

    @Override
    int getOffset() {
        return this.buffer.length();
    }

    @Override
    int newlinesEmitted() {
        return this.newlinesEmitted;
    }
}

