/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.css;

import java.io.IOException;
import java.io.Reader;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.css.CSSLexerTokenizer;
import oracle.javatools.parser.css.CSSTokenizer;
import oracle.javatools.parser.css.CSSTokens;
import oracle.javatools.parser.css.ParseException;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public class CSSLexer
extends FastLexer
implements CSSTokens {
    protected int _mLastToken;
    protected int _mStartOffset;
    protected int _mEndOffset;
    protected boolean _mUseLastToken;
    private CSSTokenizer _mTokenizer;
    protected TextBufferReader _mReader;
    protected LineMap _mLineMap;

    public void setLineMap(LineMap lineMap) {
        this._mLineMap = lineMap;
    }

    @Override
    public void setPosition(int offset) {
        super.setPosition(offset);
        this.resetTokenizer();
    }

    @Override
    public int lex(LexerToken lexedToken) {
        if (this._mUseLastToken) {
            this._mUseLastToken = false;
            return this.fillLexerToken(lexedToken);
        }
        this._mUseLastToken = false;
        this._mLastToken = 0;
        CSSTokenizer Tokenizer2 = this.getTokenizer();
        switch (this.nextToken()) {
            case 18: {
                this.updateState();
                break;
            }
            case 17: {
                this.updateState();
                break;
            }
            case 21: 
            case 22: {
                this.updateState();
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 55: 
            case 68: 
            case 69: {
                this.updateState();
                this.skipAtRule();
                this._mEndOffset = Tokenizer2.getEnd();
                break;
            }
            case 7: 
            case 13: 
            case 20: 
            case 27: 
            case 42: {
                this._mStartOffset = Tokenizer2.getStart();
                this._mLastToken = this.skipStyleRule();
                this._mEndOffset = Tokenizer2.getEnd();
                break;
            }
            default: {
                this.updateState();
            }
        }
        return this.fillLexerToken(lexedToken);
    }

    @Override
    public void backup() {
        this._mUseLastToken = true;
    }

    protected int skipStyleRule() {
        int bracesLevel = 0;
        block5: while (true) {
            switch (this.nextToken()) {
                case 1: {
                    ++bracesLevel;
                    continue block5;
                }
                case 2: {
                    if (--bracesLevel > 0) continue block5;
                    break block5;
                }
                case 0: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return 100;
    }

    protected int skipBlock() {
        int bracesLevel = 1;
        block5: while (bracesLevel > 0) {
            switch (this.nextToken()) {
                case 1: {
                    ++bracesLevel;
                    continue block5;
                }
                case 2: {
                    --bracesLevel;
                    continue block5;
                }
                case 0: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        return 101;
    }

    protected int skipAtRule() {
        try {
            this._mTokenizer.scanAtRule();
        }
        catch (Throwable er) {
            er.printStackTrace();
        }
        int next = this.nextToken();
        return 29;
    }

    protected int fillLexerToken(LexerToken lexedToken) {
        if (lexedToken == null) {
            return this._mLastToken;
        }
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this._mLastToken);
        outToken.setStartOffset(this._mStartOffset);
        outToken.setEndOffset(this._mEndOffset);
        return this._mLastToken;
    }

    protected void resetTokenizer() {
        if (this._mTokenizer == null) {
            this.getTokenizer();
        }
        if (this.currentPos == 0) {
            this._mReader.current = 0;
            this._mTokenizer.reset();
            this._mUseLastToken = false;
        } else {
            int newPosition = this.currentPos;
            int newLine = 0;
            int newColumn = 0;
            if (this._mLineMap != null) {
                newLine = this._mLineMap.getLineFromOffset(newPosition);
                newColumn = this._mLineMap.getLineEndOffset(newLine) - newPosition;
            }
            this._mReader.current = newPosition;
            this._mTokenizer.setPosition(newPosition, newLine, newColumn);
            this._mUseLastToken = false;
        }
    }

    protected int nextToken() {
        try {
            int type = this._mTokenizer.next();
            return type;
        }
        catch (ParseException e) {
            if (e.getException() != null && e.getException() instanceof IOException) {
                return 0;
            }
            return -1;
        }
    }

    CSSTokenizer getTokenizer() {
        if (this._mTokenizer == null) {
            this._mReader = new TextBufferReader();
            this._mTokenizer = new CSSLexerTokenizer(this._mReader);
        }
        return this._mTokenizer;
    }

    protected void updateState() throws ParseException {
        this._mLastToken = this._mTokenizer.getType();
        this._mStartOffset = this._mTokenizer.getStart();
        this._mEndOffset = this._mTokenizer.getEnd();
        this.convertToken();
    }

    protected void convertToken() {
        this._mLastToken = this.TokenizerToLanguageToken(this._mLastToken);
    }

    @Override
    public int getToken() {
        return this._mLastToken;
    }

    @Override
    public int getStartOffset() {
        return this._mStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this._mEndOffset;
    }

    @Override
    public int lex() {
        return this.lex(null);
    }

    protected int TokenizerToLanguageToken(int token) {
        switch (token) {
            case 0: {
                return 0;
            }
        }
        return token;
    }

    class TextBufferReader
    extends Reader {
        int current = 0;

        TextBufferReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int length = CSSLexer.this.textBuffer.getLength();
            int dl = length - (this.current + len);
            if (dl < 0) {
                len += dl;
            }
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    cbuf[off + i] = CSSLexer.this.textBuffer.getChar(this.current++);
                }
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            if (this.current >= CSSLexer.this.textBuffer.getLength()) {
                return -1;
            }
            return CSSLexer.this.textBuffer.getChar(this.current++);
        }
    }
}

