/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.lang.reflect.Constructor;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public class HashStructureAdapter {
    protected final HashStructure _hash;
    private boolean _useObjectEquals = false;

    protected HashStructureAdapter(HashStructure hash) {
        this(hash, null);
    }

    protected HashStructureAdapter(HashStructure hash, HashStructure.Filter filter) {
        if (hash == null) {
            throw new IllegalArgumentException("hash is null");
        }
        this._hash = filter != null ? HashStructure.newHashStructureFilteredImpl(hash, filter) : hash;
    }

    protected static HashStructure findOrCreate(PropertyStorage storage, String name) {
        return storage != null ? storage.getProperties().getOrCreateHashStructure(name) : HashStructure.newInstance();
    }

    protected final void useObjectEquals() {
        this._useObjectEquals = true;
    }

    public Object copyTo(Object target) {
        if (target == null) {
            try {
                Class<?> type = this.getClass();
                Class[] ctorArgTypes = new Class[]{HashStructure.class};
                Constructor<?> ctor = type.getDeclaredConstructor(ctorArgTypes);
                if (ctor != null) {
                    ctor.setAccessible(true);
                    Object[] args = new Object[]{HashStructure.newInstance()};
                    target = ctor.newInstance(args);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.isSameTypeAs(target)) {
            throw new IllegalArgumentException("Attempt to copy from an object of type " + this.getClass().getName() + " to an object of type " + (target != null ? target.getClass().getName() : "<null>"));
        }
        this.copyToImpl((HashStructureAdapter)target);
        return target;
    }

    public final void forcedCopyTo(HashStructureAdapter copy) {
        if (copy != null) {
            this.copyToImpl(copy);
        }
    }

    protected final void copyToImpl(final HashStructureAdapter copy) {
        copy._hash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                HashStructureAdapter.this._hash.copyTo(copy._hash);
            }
        });
    }

    public boolean containsKey(String key) {
        return this._hash.containsKey(key);
    }

    public void addStructureChangeListener(StructureChangeListener sl) {
        this._hash.addStructureChangeListener(sl);
    }

    public void removeStructureChangeListener(StructureChangeListener sl) {
        this._hash.removeStructureChangeListener(sl);
    }

    protected HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (this._useObjectEquals) {
            return super.equals(o);
        }
        return this.isSameTypeAs(o) ? this.equalsImpl((HashStructureAdapter)o) : false;
    }

    protected final boolean equalsImpl(HashStructureAdapter other) {
        return this._hash.equals(other._hash);
    }

    private boolean isSameTypeAs(Object o) {
        return o != null && o.getClass() == this.getClass();
    }
}

