/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.sequence;

import java.util.ArrayList;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public class SequenceCompareAlgorithm
implements CompareAlgorithm {
    @Override
    public boolean canCompare(CompareContributor first, CompareContributor second) {
        return true;
    }

    @Override
    public CompareModel compare(CompareContributor first, CompareContributor second) throws CompareFailedException {
        SequenceCompareContributor one = (SequenceCompareContributor)first;
        SequenceCompareContributor two = (SequenceCompareContributor)second;
        SequenceCompareDifference[] diffs = this.getDifferences(one, two);
        if (diffs == null) {
            diffs = new SequenceCompareDifference[]{new SequenceCompareDifference(2)};
            diffs[0].setFirstStart(0);
            diffs[0].setFirstLength(one.getLength());
            diffs[0].setSecondStart(0);
            diffs[0].setSecondLength(two.getLength());
        }
        return new SequenceCompareModel(one, two, diffs);
    }

    private void dumpBlocks(SequenceCompareDifference[] blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            SequenceCompareDifference thisBlock = blocks[i];
            System.err.println(i + ": " + thisBlock.getKind() + " (" + thisBlock._firstStart + ", " + thisBlock._firstLength + " ) => (" + thisBlock._secondStart + ", " + thisBlock._secondLength + " )");
        }
    }

    protected SequenceCompareDifference[] getDifferences(SequenceCompareContributor first, SequenceCompareContributor second) {
        int upper;
        int row;
        int secondLen = second.getLength();
        int firstLen = first.getLength();
        if (firstLen == secondLen && secondLen == 1) {
            if (!this.equal(first, 0, second, 0)) {
                SequenceCompareDifference[] diffs = new SequenceCompareDifference[]{new SequenceCompareDifference(2)};
                diffs[0].setFirstStart(0);
                diffs[0].setFirstLength(1);
                diffs[0].setSecondStart(0);
                diffs[0].setSecondLength(1);
                return diffs;
            }
            return new SequenceCompareDifference[0];
        }
        int dLength = 2 * Math.max(secondLen, firstLen);
        int origin = dLength / 2;
        int[] last_d = new int[dLength + 1];
        LinkedDifferenceBlock[] differences = new LinkedDifferenceBlock[dLength + 1];
        for (row = 0; row < secondLen && row < firstLen && this.equal(second, row, first, row); ++row) {
        }
        last_d[origin] = row;
        differences[origin] = null;
        int lower = row == secondLen ? origin + 1 : origin - 1;
        int n = upper = row == firstLen ? origin - 1 : origin + 1;
        if (lower > upper) {
            return new SequenceCompareDifference[0];
        }
        for (int d = 1; d < dLength; ++d) {
            for (int k = lower; k <= upper; k += 2) {
                int column;
                LinkedDifferenceBlock difference;
                if (k == origin - d || k != origin + d && last_d[k + 1] >= last_d[k - 1]) {
                    row = last_d[k + 1] + 1;
                    difference = new LinkedDifferenceBlock(differences[k + 1], 1);
                } else {
                    row = last_d[k - 1];
                    difference = new LinkedDifferenceBlock(differences[k - 1], 0);
                }
                difference.setLeftStart(column);
                difference.setRightStart(row);
                differences[k] = difference;
                for (column = row + k - origin; row < secondLen && column < firstLen && this.equal(second, row, first, column); ++row, ++column) {
                }
                last_d[k] = row;
                if (row == secondLen && column == firstLen) {
                    return this.coalesceDiffs(differences[k]);
                }
                if (row == secondLen) {
                    lower = k + 2;
                }
                if (column != firstLen) continue;
                upper = k - 2;
            }
            --lower;
            ++upper;
        }
        return null;
    }

    private void dumpBlocks(LinkedDifferenceBlock start) {
        do {
            System.err.print(start.getKind() == 0 ? "INS: (" : "DEL: (");
            System.err.print(start._firstStart + ", " + start._secondStart);
            System.err.println(")");
        } while ((start = start._next) != null);
    }

    private SequenceCompareDifference[] coalesceDiffs(LinkedDifferenceBlock start) {
        LinkedDifferenceBlock linkedBlock = this.reverse(start);
        ArrayList<SequenceCompareDifference> result = new ArrayList<SequenceCompareDifference>();
        SequenceCompareDifference diffBlock = null;
        while (linkedBlock != null) {
            diffBlock = new SequenceCompareDifference(2);
            if (linkedBlock._kind == 0) {
                diffBlock._secondStart = linkedBlock._secondStart + 1;
                diffBlock._firstStart = linkedBlock._firstStart;
                LinkedDifferenceBlock b = linkedBlock;
                do {
                    linkedBlock = linkedBlock.getNext();
                    ++diffBlock._firstLength;
                } while (linkedBlock != null && linkedBlock._kind == 0 && linkedBlock._secondStart == b._secondStart);
            } else {
                boolean isChange;
                diffBlock._secondStart = linkedBlock._secondStart;
                diffBlock._firstStart = linkedBlock._firstStart;
                LinkedDifferenceBlock a = linkedBlock;
                do {
                    a = linkedBlock;
                    linkedBlock = linkedBlock.getNext();
                    ++diffBlock._secondLength;
                } while (linkedBlock != null && linkedBlock._kind == 1 && linkedBlock._secondStart == a._secondStart + 1);
                boolean bl = isChange = linkedBlock != null && linkedBlock._kind == 0 && linkedBlock._secondStart == a._secondStart;
                if (isChange) {
                    LinkedDifferenceBlock b = linkedBlock;
                    do {
                        linkedBlock = linkedBlock.getNext();
                        ++diffBlock._firstLength;
                    } while (linkedBlock != null && linkedBlock._kind == 0 && linkedBlock._secondStart == b._secondStart);
                } else {
                    diffBlock._firstLength = 0;
                }
                ++diffBlock._firstStart;
            }
            --diffBlock._secondStart;
            --diffBlock._firstStart;
            result.add(diffBlock);
        }
        return result.toArray(new SequenceCompareDifference[0]);
    }

    private LinkedDifferenceBlock reverse(LinkedDifferenceBlock block) {
        LinkedDifferenceBlock current = null;
        for (LinkedDifferenceBlock ahead = block; ahead != null; ahead = ahead.getNext()) {
            LinkedDifferenceBlock behind = current;
            current = ahead;
            current.setNext(behind);
        }
        return current;
    }

    protected boolean equal(SequenceCompareContributor first, int index, SequenceCompareContributor second, int index2) {
        return first.equal(index, second, index2);
    }

    private class LinkedDifferenceBlock {
        public static final int INSERT = 0;
        public static final int DELETE = 1;
        private LinkedDifferenceBlock _next;
        private int _kind;
        private int _firstStart;
        private int _secondStart;

        LinkedDifferenceBlock() {
        }

        LinkedDifferenceBlock(LinkedDifferenceBlock next, int kind) {
            this._kind = kind;
            this._next = next;
        }

        int getKind() {
            return this._kind;
        }

        void setKind(int kind) {
            this._kind = kind;
        }

        void setLeftStart(int leftStart) {
            this._firstStart = leftStart;
        }

        void setRightStart(int rightStart) {
            this._secondStart = rightStart;
        }

        LinkedDifferenceBlock getNext() {
            return this._next;
        }

        void setNext(LinkedDifferenceBlock block) {
            this._next = block;
        }
    }
}

