/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.list.CompareList;
import oracle.javatools.compare.algorithm.list.CompareListItem;
import oracle.javatools.compare.algorithm.list.ListCompareContributor;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;

public class ListCompareAlgorithm
implements CompareAlgorithm {
    private boolean _emitNoChange;

    @Override
    @Deprecated
    public boolean canCompare(CompareContributor first, CompareContributor second) {
        return true;
    }

    @Override
    public CompareModel compare(CompareContributor first, CompareContributor second) throws CompareFailedException {
        SequenceCompareDifference difference;
        ListCompareContributor dccF = (ListCompareContributor)first;
        ListCompareContributor dccS = (ListCompareContributor)second;
        CompareList listF = dccF.getCompareList();
        CompareList listS = dccS.getCompareList();
        ArrayList<CompareListItem> lhsItems = new ArrayList<CompareListItem>(Arrays.asList(listF.getItems()));
        ArrayList<CompareListItem> rhsItems = new ArrayList<CompareListItem>(Arrays.asList(listS.getItems()));
        ArrayList<CompareListItem> lhsOnlyItems = new ArrayList<CompareListItem>(lhsItems);
        lhsOnlyItems.removeAll(rhsItems);
        ArrayList<CompareListItem> rhsOnlyItems = new ArrayList<CompareListItem>(rhsItems);
        rhsOnlyItems.removeAll(lhsItems);
        lhsItems.removeAll(lhsOnlyItems);
        rhsItems.removeAll(rhsOnlyItems);
        ArrayList<CompareListItem> changeItems = new ArrayList<CompareListItem>();
        ArrayList<CompareListItem> nochangeItems = null;
        if (this._emitNoChange) {
            nochangeItems = new ArrayList<CompareListItem>();
        }
        for (CompareListItem lhsItem : lhsItems) {
            CompareListItem rhsItem;
            if (lhsItem.compareTo(rhsItem = rhsItems.get(rhsItems.indexOf(lhsItem))) != 0) {
                changeItems.add(lhsItem);
                continue;
            }
            if (!this._emitNoChange) continue;
            nochangeItems.add(lhsItem);
        }
        ArrayList<SequenceCompareDifference> differences = new ArrayList<SequenceCompareDifference>();
        if (this._emitNoChange) {
            for (CompareListItem item : nochangeItems) {
                difference = new SequenceCompareDifference(0);
                difference.setFirstStart(listF.indexOf(item));
                difference.setFirstLength(1);
                difference.setSecondStart(listS.indexOf(item));
                difference.setSecondLength(1);
                differences.add(difference);
            }
        }
        for (CompareListItem item : lhsOnlyItems) {
            difference = new SequenceCompareDifference(2);
            difference.setFirstStart(listF.indexOf(item));
            difference.setFirstLength(1);
            difference.setSecondStart(Math.abs(listS.binarySearch(item) + 1));
            difference.setSecondLength(0);
            differences.add(difference);
        }
        for (CompareListItem item : rhsOnlyItems) {
            difference = new SequenceCompareDifference(2);
            difference.setFirstStart(Math.abs(listF.binarySearch(item) + 1));
            difference.setFirstLength(0);
            difference.setSecondStart(listS.indexOf(item));
            difference.setSecondLength(1);
            differences.add(difference);
        }
        for (CompareListItem item : changeItems) {
            difference = new SequenceCompareDifference(2);
            difference.setFirstStart(listF.indexOf(item));
            difference.setFirstLength(1);
            difference.setSecondStart(listS.indexOf(item));
            difference.setSecondLength(1);
            differences.add(difference);
        }
        Collections.sort(differences, new Comparator<SequenceCompareDifference>(){

            @Override
            public int compare(SequenceCompareDifference o1, SequenceCompareDifference o2) {
                int i = o1.getStart(ContributorKind.FIRST) - o2.getStart(ContributorKind.FIRST);
                if (i != 0) {
                    return i;
                }
                i = o1.getStart(ContributorKind.SECOND) - o2.getStart(ContributorKind.SECOND);
                if (i != 0) {
                    return i;
                }
                i = o1.getStart(ContributorKind.ANCESTOR) - o2.getStart(ContributorKind.ANCESTOR);
                return i;
            }
        });
        return new SequenceCompareModel((ListCompareContributor)first, (ListCompareContributor)second, differences.toArray(new SequenceCompareDifference[0]));
    }

    public final void setEmitNoChangeDifferences(boolean emitNoChange) {
        this._emitNoChange = emitNoChange;
    }
}

