/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Version;
import oracle.ide.feedback.FeedbackLogOptions;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.ReadWriteLockImplementation;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.parser.java.v2.common.NullPrintWriter;
import oracle.javatools.util.Log;

class JdkReadWriteLockImplementation
extends ReentrantReadWriteLock
implements ReadWriteLockImplementation {
    private final ReadWriteLock lock;
    private final boolean logUpgrades;
    private final boolean logDeadlocks;
    private final boolean logDialogs;
    private final int deadlockInterval;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private static final int PUBLIC_LOCK_METHOD_INDEX = 2;
    private static final Logger LOGGER = Logger.getLogger("oracle.javatools.lock");

    JdkReadWriteLockImplementation(ReadWriteLock lock, EnumSet<ReadWriteLock.Options> options, int deadlockInterval) {
        super(options.contains((Object)ReadWriteLock.Options.FAIR));
        this.lock = lock;
        this.logUpgrades = options.contains((Object)ReadWriteLock.Options.UPGRADES);
        this.logDeadlocks = options.contains((Object)ReadWriteLock.Options.DEADLOCKS);
        this.logDialogs = options.contains((Object)ReadWriteLock.Options.DIALOGS);
        this.deadlockInterval = deadlockInterval;
        this.readLock = this.readLock();
        this.writeLock = this.writeLock();
    }

    @Override
    public boolean readLock(boolean block) {
        return this.lock(this.readLock, block);
    }

    @Override
    public void readLockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(this.readLock);
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public boolean writeLock(boolean block) {
        this.throwUpgrade();
        return this.lock(this.writeLock, block);
    }

    @Override
    public void writeLockInterruptibly() throws InterruptedException {
        this.throwUpgrade();
        this.lockInterruptibly(this.writeLock);
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public int releaseReaders() {
        int readCount = this.getReadHoldCount();
        for (int i = 0; i < readCount; ++i) {
            this.readLock.unlock();
        }
        return readCount;
    }

    @Override
    public void restoreReaders(int readerCount) {
        while (--readerCount >= 0) {
            this.readLock.lock();
        }
    }

    private void throwUpgrade() {
        if (this.getReadHoldCount() > 0 && !this.isWriteLockedByCurrentThread()) {
            IllegalMonitorStateException exception = new IllegalMonitorStateException(this.lock + " upgraded");
            if (this.logUpgrades) {
                StackTraceElement element;
                int depth;
                StackTraceElement[] trace = exception.getStackTrace();
                for (depth = 3; depth < trace.length && "oracle.javatools.buffer.JdkReadWriteLockImplementation".equals((element = trace[depth]).getClassName()); ++depth) {
                }
                Thread thread = Thread.currentThread();
                StringBuilder buffer = new StringBuilder();
                this.appendThreadState(buffer, thread, false, trace);
                LOGGER.log(Level.SEVERE, "lock upgrade; {0} upgraded on thread ''{1}'':{2}", new Object[]{this.lock, thread.getName(), buffer, new FeedbackLogOptions((Throwable)exception, depth)});
            }
            throw exception;
        }
    }

    private boolean lock(Lock lock, boolean block) {
        if (block) {
            if (this.logDeadlocks) {
                long start;
                boolean interrupted = false;
                for (long interval = (long)this.deadlockInterval; interval > 0L; interval -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    try {
                        boolean locked = lock.tryLock(interval, TimeUnit.MILLISECONDS);
                        if (locked) {
                            return true;
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                }
                DeadlockScanner.ScanRequest request = DeadlockScanner.scan(this, this.logDialogs);
                lock.lock();
                request.cancel();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                lock.lock();
            }
            return true;
        }
        return lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockInterruptibly(Lock lock) throws InterruptedException {
        if (this.logDeadlocks) {
            boolean locked = lock.tryLock(this.deadlockInterval, TimeUnit.MILLISECONDS);
            if (locked) {
                return;
            }
            DeadlockScanner.ScanRequest request = DeadlockScanner.scan(this, this.logDialogs);
            try {
                lock.lockInterruptibly();
            }
            finally {
                request.cancel();
            }
        } else {
            lock.lockInterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendSnapshot(StringBuilder buffer) {
        try (MergedWriter writer = new MergedWriter(buffer);){
            writer.println();
            writer.printBanner("Snapshot for " + this.lock);
            JdkReadWriteLockImplementation.writeSnapshot(Collections.singleton(this), writer);
        }
    }

    @Override
    public void setEventLog(Log log) {
    }

    private void appendThreadState(StringBuilder buffer, Thread thread, boolean blocked, StackTraceElement[] currentTrace) {
        buffer.append("\n\"");
        buffer.append(thread.getName());
        buffer.append("\" id=");
        buffer.append(thread.getId());
        buffer.append(", ");
        if (blocked) {
            buffer.append("blocked, ");
        }
        JdkReadWriteLockImplementation.appendCounted(buffer, this.getReadHoldCount(), " read", ":\n");
        JdkReadWriteLockImplementation.appendStackTrace(buffer, currentTrace);
    }

    private static void writeSnapshot(Collection<ReentrantReadWriteLock> locks, MergedWriter writer) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threads = bean.getThreadInfo(bean.getAllThreadIds(), bean.isObjectMonitorUsageSupported(), bean.isSynchronizerUsageSupported());
        ArrayList<ThreadInfo> included = new ArrayList<ThreadInfo>();
        ArrayList<ThreadInfo> excluded = new ArrayList<ThreadInfo>();
        try {
            JdkReadWriteLockImplementation.partition(threads, locks, included, excluded);
            for (ThreadInfo thread : included) {
                JdkReadWriteLockImplementation.writeThread(bean, thread, writer);
            }
        }
        catch (NoSuchFieldException e) {
            writer.print("Exception getting 'sync' field:");
            writer.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            writer.print("Exception getting 'sync' field:");
            writer.println(e.getMessage());
        }
    }

    private static void partition(ThreadInfo[] threads, Collection<ReentrantReadWriteLock> locks, Collection<ThreadInfo> included, Collection<ThreadInfo> excluded) throws NoSuchFieldException, IllegalAccessException {
        HashSet<Integer> codes = new HashSet<Integer>();
        Field field = ReentrantReadWriteLock.class.getDeclaredField("sync");
        field.setAccessible(true);
        for (ReentrantReadWriteLock lock : locks) {
            codes.add(System.identityHashCode(field.get(lock)));
        }
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            boolean found = false;
            LockInfo awaited = thread.getLockInfo();
            if (awaited != null && codes.contains(awaited.getIdentityHashCode())) {
                found = true;
            } else {
                for (LockInfo owned : thread.getLockedSynchronizers()) {
                    if (!codes.contains(owned.getIdentityHashCode())) continue;
                    found = true;
                    break;
                }
            }
            if (found) {
                included.add(thread);
                continue;
            }
            excluded.add(thread);
        }
    }

    private static void writeThread(ThreadMXBean bean, ThreadInfo thread, MergedWriter writer) {
        LockInfo[] locks;
        writer.print("\"");
        writer.print(thread.getThreadName());
        writer.print("\" id=");
        writer.print(thread.getThreadId());
        writer.print(" ");
        writer.print((Object)thread.getThreadState());
        String lockName = thread.getLockName();
        if (lockName != null) {
            writer.print(" on ");
            writer.print(lockName);
        }
        if (thread.getLockOwnerName() != null) {
            writer.print(" owned by \"");
            writer.print(thread.getLockOwnerName());
            writer.print("\" id=");
            writer.print(thread.getLockOwnerId());
        }
        if (thread.isSuspended()) {
            writer.print(" (suspended)");
        }
        if (thread.isInNative()) {
            writer.print(" (in native)");
        }
        writer.println();
        StackTraceElement[] stackTrace = thread.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            writer.print("\tat ");
            writer.println(stackTrace[i]);
            if (i == 0 && lockName != null) {
                Thread.State ts = thread.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        writer.print("\t-  blocked on ");
                        writer.println(lockName);
                        break;
                    }
                    case WAITING: {
                        writer.print("\t-  waiting on ");
                        writer.println(lockName);
                        break;
                    }
                    case TIMED_WAITING: {
                        writer.print("\t-  waiting on ");
                        writer.println(lockName);
                        break;
                    }
                }
            }
            if (!bean.isObjectMonitorUsageSupported()) continue;
            for (LockInfo lockInfo : thread.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                writer.print("\t-  locked ");
                writer.println(lockInfo);
            }
        }
        if (bean.isSynchronizerUsageSupported() && (locks = thread.getLockedSynchronizers()).length > 0) {
            writer.println();
            writer.println("\tLocked synchronizers:");
            for (LockInfo lockInfo : locks) {
                writer.print("\t- ");
                writer.println(lockInfo);
            }
        }
    }

    private static void appendStackTrace(StringBuilder buffer, StackTraceElement[] trace) {
        if (trace == null || trace.length == 0) {
            buffer.append("\t[No trace available]\n");
            return;
        }
        for (int i = 0; i < trace.length; ++i) {
            if (trace[i].getClassName().equals("oracle.javatools.buffer.JdkReadWriteLockImplementation")) continue;
            buffer.append("\tat ");
            buffer.append(trace[i]);
            buffer.append('\n');
        }
    }

    private static void appendCounted(StringBuilder buffer, int count, String head, String tail) {
        if (count == 0) {
            buffer.append("no");
        } else {
            buffer.append(count);
        }
        buffer.append(head);
        if (count == 0 || count > 1) {
            buffer.append('s');
        }
        buffer.append(tail);
    }

    private static class MergedWriter
    implements Appendable {
        public static final int CONSOLE = -1;
        public static final int FILE = 1;
        public static final int BOTH = 0;
        private int destination = 0;
        private StringBuilder builder;
        private File file;
        private PrintWriter writer;
        private final String EOL = System.getProperty("line.separator");

        public MergedWriter(String name) {
            this.builder = new StringBuilder();
            this.file = Diagnostics.newFile(name);
            if (this.file != null) {
                try {
                    this.writer = new PrintWriter(this.file);
                }
                catch (FileNotFoundException e) {
                    this.writer = new NullPrintWriter();
                    this.file = null;
                }
            } else {
                this.writer = new NullPrintWriter();
            }
        }

        public MergedWriter(StringBuilder builder) {
            this.builder = builder;
            this.writer = new NullPrintWriter();
            this.file = null;
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }

        public File getFile() {
            return this.file;
        }

        public void setDestination(int destination) {
            this.destination = destination;
        }

        @Override
        public MergedWriter append(CharSequence csq) throws IOException {
            this.print(csq);
            return this;
        }

        @Override
        public MergedWriter append(CharSequence csq, int start, int end) throws IOException {
            return null;
        }

        @Override
        public MergedWriter append(char c) throws IOException {
            return null;
        }

        public void print(String value) {
            if (this.destination <= 0) {
                this.builder.append(value);
            }
            if (this.destination >= 0) {
                this.writer.append(value);
            }
        }

        public void print(Integer value) {
            if (this.destination <= 0) {
                this.builder.append(value);
            }
            if (this.destination >= 0) {
                this.writer.append(String.valueOf(value));
            }
        }

        public void print(Long value) {
            if (this.destination <= 0) {
                this.builder.append(value);
            }
            if (this.destination >= 0) {
                this.writer.append(String.valueOf(value));
            }
        }

        public void print(Object value) {
            if (this.destination <= 0) {
                this.builder.append(value);
            }
            if (this.destination >= 0) {
                this.writer.append(String.valueOf(value));
            }
        }

        public void println(String value) {
            if (this.destination <= 0) {
                this.builder.append(value).append(this.EOL);
            }
            if (this.destination >= 0) {
                this.writer.append(value).println();
            }
        }

        public void println(Object value) {
            if (this.destination <= 0) {
                this.builder.append(value).append(this.EOL);
            }
            if (this.destination >= 0) {
                this.writer.append(String.valueOf(value)).println();
            }
        }

        public void println() {
            if (this.destination <= 0) {
                this.builder.append(this.EOL);
            }
            if (this.destination >= 0) {
                this.writer.println();
            }
        }

        public void printBanner(String string) {
            if (this.destination <= 0) {
                StringWriter writer = new StringWriter();
                Diagnostics.writeBanner(writer, string);
                this.builder.append(writer.getBuffer());
            }
            if (this.destination >= 0) {
                Diagnostics.writeBanner(this.writer, string);
            }
        }

        public void printFootnote() {
            if (this.file != null) {
                this.builder.append(this.EOL);
                this.builder.append("See full log at \"");
                this.builder.append(this.file.getAbsolutePath());
                this.builder.append("\"");
            }
            this.builder.append(this.EOL);
        }

        public void close() {
            this.writer.close();
        }
    }

    private static class DeadlockScanner
    extends Thread {
        public static final long DETECTION_DELAY_NANO = 1000L;
        private static Thread thread;
        private static BlockingQueue<ScanRequest> unqueuedRequests;
        private Set<Set<ReentrantReadWriteLock>> starvations = new HashSet<Set<ReentrantReadWriteLock>>();

        private static synchronized ScanRequest scan(ReentrantReadWriteLock lock, boolean logDialogs) {
            if (thread == null) {
                thread = new DeadlockScanner();
                unqueuedRequests = new DelayQueue<ScanRequest>();
                thread.start();
            }
            ScanRequest request = new ScanRequest(lock, Thread.currentThread(), logDialogs);
            unqueuedRequests.add(request);
            return request;
        }

        private DeadlockScanner() {
            super("deadlock-scanner");
        }

        @Override
        public void run() {
            ArrayList<ScanRequest> queuedRequests = new ArrayList<ScanRequest>();
            while (true) {
                ScanRequest request;
                try {
                    request = unqueuedRequests.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (!request.isCancelled()) {
                    if (!request.getLock().hasQueuedThread(request.thread)) {
                        request.reset();
                        boolean accepted = unqueuedRequests.offer(request);
                        if (!accepted) {
                            throw new IllegalStateException("unbounded queue rejected offer");
                        }
                    } else {
                        queuedRequests.add(request);
                    }
                }
                if (!unqueuedRequests.isEmpty() || queuedRequests.isEmpty()) continue;
                Iterator i = queuedRequests.iterator();
                while (i.hasNext()) {
                    request = (ScanRequest)i.next();
                    if (!request.isCancelled()) continue;
                    i.remove();
                }
                if (queuedRequests.isEmpty() || !unqueuedRequests.isEmpty()) continue;
                this.scan(queuedRequests);
                queuedRequests.clear();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scan(List<ScanRequest> requests) {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            long[] deadIds = bean.isSynchronizerUsageSupported() ? bean.findDeadlockedThreads() : bean.findMonitorDeadlockedThreads();
            ThreadInfo[] threads = bean.getThreadInfo(bean.getAllThreadIds(), bean.isObjectMonitorUsageSupported(), bean.isSynchronizerUsageSupported());
            ArrayList<ThreadInfo> included = new ArrayList<ThreadInfo>();
            ArrayList<ThreadInfo> excluded = new ArrayList<ThreadInfo>();
            if (deadIds == null) {
                boolean suppressBecauseShowingDialog = true;
                HashSet<ReentrantReadWriteLock> locks = new HashSet<ReentrantReadWriteLock>();
                for (ScanRequest request : requests) {
                    if (request.isLogDialogs()) {
                        suppressBecauseShowingDialog = false;
                    }
                    locks.add(request.getLock());
                }
                if (this.starvations.contains(locks)) {
                    return;
                }
                this.starvations.add(locks);
                try {
                    JdkReadWriteLockImplementation.partition(threads, locks, included, excluded);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    included.addAll(Arrays.asList(threads));
                }
                catch (IllegalAccessException illegalAccessException) {
                    included.addAll(Arrays.asList(threads));
                }
                if (suppressBecauseShowingDialog) {
                    for (ThreadInfo thread : included) {
                        StackTraceElement[] trace;
                        for (StackTraceElement element : trace = thread.getStackTrace()) {
                            if (!"java.awt.Dialog".equals(element.getClassName()) || !"show".equals(element.getMethodName())) continue;
                            return;
                        }
                    }
                }
            } else {
                void var9_22;
                Arrays.sort(deadIds);
                ThreadInfo[] suppressBecauseShowingDialog = threads;
                int n = suppressBecauseShowingDialog.length;
                boolean bl = false;
                while (var9_22 < n) {
                    ThreadInfo thread;
                    thread = suppressBecauseShowingDialog[var9_22];
                    if (thread != null) {
                        if (Arrays.binarySearch(deadIds, thread.getThreadId()) >= 0) {
                            included.add(thread);
                        } else {
                            excluded.add(thread);
                        }
                    }
                    ++var9_22;
                }
            }
            MergedWriter writer = new MergedWriter(deadIds != null ? "DEADLOCK" : "STARVATION");
            try {
                writer.setDestination(0);
                writer.println(deadIds != null ? "Deadlock detected:" : "Starvation (possible deadlock) detected:");
                writer.print("Oracle ");
                writer.print(Version.NAME_SHORT);
                writer.print(" ");
                writer.print(Version.VER);
                writer.print(" ");
                writer.print(Version.BUILD_NUM);
                writer.print(" (");
                writer.print(Version.BUILD_LABEL);
                writer.println(")");
                writer.print(System.getProperty("java.vendor"));
                writer.print(" Java ");
                writer.println(System.getProperty("java.runtime.version"));
                writer.print(Runtime.getRuntime().freeMemory() / 1000000L);
                writer.print("MB free of ");
                writer.print(Runtime.getRuntime().maxMemory() / 1000000L);
                writer.println("MB");
                if (deadIds != null) {
                    writer.setDestination(0);
                    writer.println();
                    writer.printBanner("Deadlock Summary");
                    writer.println();
                    for (ThreadInfo threadInfo : included) {
                        if (threadInfo == null) continue;
                        writer.print("\"");
                        writer.print(threadInfo.getThreadName());
                        writer.print("\" id=");
                        writer.print(threadInfo.getThreadId());
                        writer.print(" ");
                        writer.print((Object)threadInfo.getThreadState());
                        String lockName = threadInfo.getLockName();
                        if (lockName != null) {
                            writer.print(" on ");
                            writer.print(lockName);
                        }
                        if (threadInfo.getLockOwnerName() != null) {
                            writer.print(" owned by \"");
                            writer.print(threadInfo.getLockOwnerName());
                            writer.print("\" id=");
                            writer.print(threadInfo.getLockOwnerId());
                        }
                        if (threadInfo.isSuspended()) {
                            writer.print(" (suspended)");
                        }
                        if (threadInfo.isInNative()) {
                            writer.print(" (in native)");
                        }
                        writer.println();
                    }
                }
                writer.setDestination(0);
                writer.println();
                writer.printBanner("Thread Dump");
                writer.println();
                writer.setDestination(0);
                for (ThreadInfo threadInfo : included) {
                    writer.println();
                    JdkReadWriteLockImplementation.writeThread(bean, threadInfo, writer);
                }
                writer.setDestination(1);
                for (ThreadInfo threadInfo : excluded) {
                    writer.println();
                    JdkReadWriteLockImplementation.writeThread(bean, threadInfo, writer);
                }
                writer.setDestination(1);
                writer.println();
                writer.printBanner("System Configuration");
                writer.println();
                for (Map.Entry entry : new ArrayList<Map.Entry<Object, Object>>(System.getProperties().entrySet())) {
                    writer.print(entry.getKey());
                    writer.print("=");
                    writer.println(entry.getValue());
                }
                writer.printFootnote();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            writer.close();
            LOGGER.log(Level.SEVERE, writer.getBuilder().toString());
        }

        public static class ScanRequest
        implements Delayed {
            private final ReentrantReadWriteLock lock;
            private final Thread thread;
            private final boolean logDialogs;
            private long time;
            private volatile boolean cancelled;

            private ScanRequest(ReentrantReadWriteLock lock, Thread thread, boolean logDialogs) {
                this.lock = lock;
                this.thread = thread;
                this.logDialogs = logDialogs;
                this.time = ScanRequest.now() + 1000L;
            }

            public void reset() {
                this.time = ScanRequest.now() + 1000L;
            }

            public void cancel() {
                this.cancelled = true;
            }

            public ReentrantReadWriteLock getLock() {
                return this.lock;
            }

            public Thread getThread() {
                return this.thread;
            }

            public boolean isLogDialogs() {
                return this.logDialogs;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public long getDelay(TimeUnit unit) {
                return unit.convert(this.time - ScanRequest.now(), TimeUnit.NANOSECONDS);
            }

            @Override
            public int compareTo(Delayed that) {
                long comparison = this.getDelay(TimeUnit.NANOSECONDS) - that.getDelay(TimeUnit.NANOSECONDS);
                return comparison == 0L ? 0 : (comparison < 0L ? -1 : 1);
            }

            public String toString() {
                return "scan request at" + this.time + " from " + this.thread + " for " + this.lock;
            }

            private static long now() {
                return System.nanoTime() - Log.TIME_ZERO_NANO;
            }
        }
    }
}

