/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;

class GapArrayTextBuffer
extends AbstractTextBuffer {
    private static final float DEFAULT_GAP_SIZE = 0.2f;
    private static final int MINIMUM_GAP_SIZE = 64;
    private static final int MAXIMUM_GAP_SIZE = 512;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] gapBuffer = new char[this.gapSize];
    private int dataSize = 0;
    private int gapOffset = 0;
    private int gapSize = 64;

    GapArrayTextBuffer(ReadWriteLock lockToUse) {
        super(lockToUse);
    }

    private int calculateGapSize(int requestedDataSize) {
        int preferredGapSize = (int)((float)requestedDataSize * 0.2f);
        preferredGapSize = Math.min(preferredGapSize, 512);
        preferredGapSize = Math.max(preferredGapSize, 64);
        return preferredGapSize;
    }

    @Override
    public int getLength() {
        return this.dataSize;
    }

    @Override
    public char getChar(int offset) throws IndexOutOfBoundsException {
        return offset < this.gapOffset ? this.gapBuffer[offset] : this.gapBuffer[offset + this.gapSize];
    }

    @Override
    public char[] getCharsImpl(int offset, int length) throws IndexOutOfBoundsException {
        this.checkOffsets(offset, length);
        char[] data = new char[length];
        int startOffset = offset;
        int endOffset = offset + length;
        if (endOffset <= this.gapOffset) {
            System.arraycopy(this.gapBuffer, startOffset, data, 0, length);
        } else if (this.gapOffset <= startOffset) {
            System.arraycopy(this.gapBuffer, startOffset + this.gapSize, data, 0, length);
        } else {
            int firstChunkSize = this.gapOffset - startOffset;
            int secondChunkSize = endOffset - this.gapOffset;
            System.arraycopy(this.gapBuffer, startOffset, data, 0, firstChunkSize);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, data, firstChunkSize, secondChunkSize);
        }
        return data;
    }

    @Override
    protected String getStringImpl(int offset, int length) throws IndexOutOfBoundsException {
        if (length == 0) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            if (offset > this.getLength()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            return "";
        }
        this.checkOffsets(offset, length);
        int startOffset = offset;
        int endOffset = offset + length;
        if (endOffset <= this.gapOffset) {
            return new String(this.gapBuffer, startOffset, length);
        }
        if (this.gapOffset <= startOffset) {
            return new String(this.gapBuffer, startOffset + this.gapSize, length);
        }
        char[] requestedData = this.getCharsImpl(offset, length);
        return new String(requestedData);
    }

    @Override
    public void getTextImpl(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        int startOffset = offset;
        int endOffset = offset + length;
        if (endOffset <= this.gapOffset) {
            segment.array = this.gapBuffer;
            segment.offset = offset;
            segment.count = length;
        } else if (this.gapOffset <= startOffset) {
            segment.array = this.gapBuffer;
            segment.offset = offset + this.gapSize;
            segment.count = length;
        } else {
            char[] data = this.getChars(offset, length);
            segment.array = data;
            segment.offset = 0;
            segment.count = length;
        }
    }

    @Override
    protected void insertImpl(int offset, char[] data, int dataOffset, int dataLength) {
        if (offset > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + offset);
        }
        int oldBufferSize = this.dataSize + this.gapSize;
        int userDataSize = dataLength;
        int newDataSize = userDataSize + this.dataSize;
        char[] newGapBuffer = this.gapBuffer;
        int newBufferSize = oldBufferSize;
        int newGapSize = this.gapSize;
        int G = this.gapOffset;
        int I = offset;
        int C1 = Math.min(G, I);
        int C2 = Math.max(G, I);
        if (userDataSize > this.gapSize) {
            newGapSize = this.calculateGapSize(newDataSize) + userDataSize;
            newBufferSize = newGapSize + this.dataSize;
            newGapBuffer = new char[newBufferSize];
            System.arraycopy(this.gapBuffer, 0, newGapBuffer, 0, C1);
            System.arraycopy(this.gapBuffer, C2 + this.gapSize, newGapBuffer, C2 + newGapSize, this.dataSize - C2);
        }
        if (G != I) {
            int moveLength = C2 - C1;
            if (G < I) {
                System.arraycopy(this.gapBuffer, C1 + this.gapSize, newGapBuffer, C1, moveLength);
            } else {
                System.arraycopy(this.gapBuffer, C1, newGapBuffer, C1 + newGapSize, moveLength);
            }
            this.gapOffset = offset;
        }
        System.arraycopy(data, dataOffset, newGapBuffer, this.gapOffset, userDataSize);
        this.gapOffset += userDataSize;
        this.gapSize = newGapSize - userDataSize;
        this.gapBuffer = newGapBuffer;
        this.dataSize = newDataSize;
    }

    @Override
    protected void removeImpl(int offset, int count) {
        this.checkOffsets(offset, 1);
        int oldBufferSize = this.dataSize + this.gapSize;
        int removeDataSize = count;
        int G = this.gapOffset;
        int S = this.gapSize;
        int RS = offset;
        int RE = offset + removeDataSize;
        if (RE < G) {
            System.arraycopy(this.gapBuffer, RE, this.gapBuffer, RE + S, G - RE);
        } else if (G < RS) {
            System.arraycopy(this.gapBuffer, G + S, this.gapBuffer, G, RS - G);
        }
        this.gapOffset = RS;
        this.gapSize += removeDataSize;
        this.dataSize -= removeDataSize;
        if (this.gapSize > 2048) {
            int newGapSize = this.calculateGapSize(this.dataSize);
            int newBufferSize = this.dataSize + newGapSize;
            char[] newGapBuffer = new char[newBufferSize];
            System.arraycopy(this.gapBuffer, 0, newGapBuffer, 0, this.gapOffset);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, newGapBuffer, this.gapOffset + newGapSize, this.dataSize - this.gapOffset);
            this.gapSize = newGapSize;
            this.gapBuffer = newGapBuffer;
        }
    }

    private void checkOffsets(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getLength()) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.getLength() + " offset: " + offset + " length: " + length);
        }
    }
}

