/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public final class URLKey {
    private final URL url;

    public static URLKey getInstance(URL url) {
        return new URLKey(url);
    }

    public static Collection<URLKey> asURLKeys(Collection<URL> urls) {
        LinkedHashSet<URLKey> keys = new LinkedHashSet<URLKey>(urls.size());
        for (URL url : urls) {
            keys.add(URLKey.getInstance(url));
        }
        return keys;
    }

    public static Collection<URL> asURLs(Collection<URLKey> keys) {
        ArrayList<URL> urls = new ArrayList<URL>(keys.size());
        for (URLKey key : keys) {
            urls.add(key.url);
        }
        return urls;
    }

    private URLKey(URL url) {
        this.url = url;
    }

    public URL toURL() {
        return this.url;
    }

    public URLKey intern() {
        URL internedUrl = URLFactory.intern(this.url);
        return this.url == internedUrl ? this : new URLKey(internedUrl);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof URLKey)) {
            return false;
        }
        URLKey other = (URLKey)o;
        return URLFileSystem.equals(this.url, other.url);
    }

    public int hashCode() {
        return URLFileSystem.hashCode(this.url);
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName(this.url);
    }
}

