/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Properties;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public final class Version {
    private static final String VERSION_PROPERTIES = "version.properties";
    @CodeSharingSafe(value="StaticField")
    private static SoftReference<Properties> propertiesRef;
    @CodeSharingSafe(value="StaticField")
    public static final String NAME_SHORT;
    @CodeSharingSafe(value="StaticField")
    public static final String NAME;
    @CodeSharingSafe(value="StaticField")
    public static final float VERSION;
    @CodeSharingSafe(value="StaticField")
    public static final String VER;
    @CodeSharingSafe(value="StaticField")
    public static final String VER_FULL;
    @CodeSharingSafe(value="StaticField")
    public static final String BUILD_LABEL;
    @CodeSharingSafe(value="StaticField")
    public static final String BUILD_NUM;
    @CodeSharingSafe(value="StaticField")
    public static final String BASE_NAMESPACE_URI;
    @CodeSharingSafe(value="StaticField")
    public static final int DEBUG_BUILD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        Properties properties;
        if (propertiesRef != null && (properties = propertiesRef.get()) != null) {
            return properties;
        }
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            File versionPropertiesFile;
            Properties systemProperties = System.getProperties();
            String confFilePath = systemProperties.getProperty("ide.conf");
            if (confFilePath != null) {
                versionPropertiesFile = new File(confFilePath).getParentFile();
                versionPropertiesFile = new File(versionPropertiesFile, VERSION_PROPERTIES);
            } else {
                versionPropertiesFile = new File(VERSION_PROPERTIES);
            }
            in = new FileInputStream(versionPropertiesFile);
            props.load(in);
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        propertiesRef = new SoftReference<Properties>(props);
        return props;
    }

    private static float initVersion() {
        float version = 11.0f;
        try {
            version = Float.parseFloat(Version.getProperties().getProperty("VERSION", "11.0"));
        }
        catch (Exception ex) {
            System.err.println("WARNING: version.properties contains an invalid VERSION property (i.e. it is not a float)");
            ex.printStackTrace();
        }
        return version;
    }

    private static int initDebugBuild() {
        int debugBuild;
        String debugFlag = System.getProperty("ide.debugbuild");
        if (debugFlag != null) {
            debugBuild = "true".equals(debugFlag) ? 1 : 0;
        } else {
            try {
                debugBuild = Integer.parseInt(Version.getProperties().getProperty("DEBUG_BUILD", "0"));
                System.setProperty("ide.debugbuild", debugBuild == 1 ? "true" : "false");
            }
            catch (Exception ex) {
                debugBuild = 0;
            }
        }
        propertiesRef = null;
        return debugBuild;
    }

    static {
        NAME_SHORT = Version.getProperties().getProperty("PRODUCT", "IDE");
        NAME = Version.getProperties().getProperty("COMPANY", "Oracle") + " " + NAME_SHORT;
        VERSION = Version.initVersion();
        VER = Version.getProperties().getProperty("VER", "11.0.0");
        VER_FULL = Version.getProperties().getProperty("VER_FULL", "11.0.0.0.0");
        BUILD_LABEL = Version.getProperties().getProperty("BUILD_LABEL", "JDEVADF_MAIN_NT_unknown");
        BUILD_NUM = Version.getProperties().getProperty("BUILD_NUM", "unknown");
        BASE_NAMESPACE_URI = Version.getProperties().getProperty("BASE_NAMESPACE_URI", "http://xmlns.oracle.com/jdeveloper/110000/");
        DEBUG_BUILD = Version.initDebugBuild();
    }
}

