/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcscore.nav;

import java.util.Observable;
import java.util.Observer;
import oracle.ide.Ide;
import oracle.ideimpl.vcscore.nav.ConnectionProvider;
import oracle.ideimpl.vcscore.nav.ConnectionProviderRegistry;

public abstract class ConnectionProviderClosure {
    private final String _extensionId;
    private final Observer _o = new Observer(){

        @Override
        public final void update(Observable o, Object arg) {
            if (ConnectionProviderClosure.this.check()) {
                ConnectionProviderRegistry.getInstance().deleteObserver(this);
            }
        }
    };

    public ConnectionProviderClosure(String extensionId) {
        this._extensionId = extensionId;
    }

    public final void run() {
        if (!Ide.getIdeArgs().getCreateUI()) {
            return;
        }
        if (!this.check()) {
            ConnectionProviderRegistry.getInstance().addObserver(this._o);
        }
    }

    protected abstract void runImpl(ConnectionProvider var1);

    private final boolean check() {
        ConnectionProvider provider = ConnectionProviderRegistry.getInstance().lookupProvider(this._extensionId);
        if (provider != null) {
            this.runImpl(provider);
            return true;
        }
        return false;
    }
}

