/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.URLPathField;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScope;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.ui.Colors;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.wizard.apptemplate.WizardDefaultsProviderManager;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardUtils;

public class ProjectPathsPanel
extends DefaultTraversablePanel {
    GridBagLayout layBottom = new GridBagLayout();
    JMultiLineLabel lblTop = new JMultiLineLabel();
    JLabel lblDefaultPkg = new JLabel();
    URLPathField fldSourcePath = new URLPathField();
    JButton btnSourcePath = new JButton();
    JTextField fldDefaultPkg = new JTextField();
    JLabel lblSourcePath = new JLabel();
    JLabel lblOutputDirectory = new JLabel();
    URLTextField fldOutputDirectory = new URLTextField();
    JButton btnOutputDirectory = new JButton();
    JPanel pnlBottom = new JPanel();
    BorderLayout layMain = new BorderLayout(0, 13);
    private URLPath _initSourcePath;
    private URL _initOutputDir;
    private TechnologyScope _prevTechScope = null;
    private URLPath _techSourcePath;
    private URL _techOutputDir;
    private String _techDefaultPackage;

    public ProjectPathsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        String defPkg;
        WizardCallbacks _callbacks;
        boolean hasTechScopeChanged;
        TechnologyScope techScope;
        block14: {
            techScope = (TechnologyScope)dataContext.getDesignTimeObject("technologyScope");
            hasTechScopeChanged = techScope != null ? !techScope.equals((Object)this._prevTechScope) : false;
            _callbacks = dataContext.getWizardCallbacks();
            String wizardName = (String)dataContext.find("WizardName");
            if (ModelUtil.hasLength((String)wizardName) && wizardName.equals(WizardsArb.getString((int)6))) {
                _callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            }
            if ((defPkg = (String)dataContext.find("DefaultPackage")) == null || hasTechScopeChanged && defPkg.equals(this._techDefaultPackage)) {
                if (dataContext.contains("ProjectURL")) {
                    try {
                        URL url = (URL)dataContext.get("ProjectURL");
                        File projectFile = new File(url.getPath());
                        defPkg = this.tryDelegating("DefaultPackage", techScope);
                        if (defPkg != null) {
                            this._techDefaultPackage = defPkg;
                            break block14;
                        }
                        defPkg = JavaProject.generateDefaultPackageName(projectFile.getName());
                    }
                    catch (Exception e) {
                        defPkg = "";
                    }
                } else {
                    defPkg = "";
                }
            }
        }
        if (defPkg != null) {
            this.fldDefaultPkg.setText(defPkg.trim());
        }
        URL projURL = (URL)dataContext.find("ProjectURL");
        Project defProj = Ide.getDefaultProject();
        URL defProjURL = defProj.getURL();
        this._initSourcePath = (URLPath)dataContext.find("ProjectSourcePath");
        if (this._initSourcePath == null || hasTechScopeChanged && this._initSourcePath.equals((Object)this._techSourcePath)) {
            String delegatedSrc = this.tryDelegating("ProjectSourcePath", techScope);
            if (delegatedSrc != null) {
                URL srcURL = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)projURL), (String)delegatedSrc);
                this._initSourcePath = new URLPath(srcURL);
            } else {
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)defProj);
                URL firstEntry = pathsConfiguration.getProjectSourcePath().getFirstEntry();
                this._initSourcePath = new URLPath(firstEntry);
                if (firstEntry == null) {
                    URL defaultProjectDir = URLFileSystem.getParent((URL)defProjURL);
                    String src = ModelArb.getString((int)16);
                    URL sourceDir = URLFactory.newDirURL((URL)defaultProjectDir, (String)src);
                    this._initSourcePath.add(sourceDir);
                }
                this._initSourcePath = ProjectWizardUtils.updateURLPath(defProjURL, projURL, this._initSourcePath);
            }
            this._techSourcePath = this._initSourcePath;
        }
        this.fldSourcePath.setURLPath(this._initSourcePath);
        this._initOutputDir = (URL)dataContext.find("OutputDirectory");
        if (this._initOutputDir == null || hasTechScopeChanged && this._initOutputDir.equals(this._techOutputDir)) {
            String outputDir = this.tryDelegating("OutputDirectory", techScope);
            URL defOutDir = outputDir != null ? URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)projURL), (String)outputDir) : JavaProject.getInstance(defProj).getOutputDirectory();
            this._techOutputDir = this._initOutputDir = ProjectWizardUtils.updateURL(defProjURL, projURL, defOutDir);
        }
        this.fldOutputDirectory.setURL(this._initOutputDir);
        if (_callbacks != null) {
            _callbacks.wizardSetInitialFocus((Component)this.fldDefaultPkg);
        }
    }

    private String tryDelegating(String wizardKey, TechnologyScope techScope) {
        WizardDefaultsProviderManager defaultsManager = WizardDefaultsProviderManager.getManager();
        if (defaultsManager.containsDefaultForTechnologyScope(techScope, wizardKey)) {
            return defaultsManager.getDefaultForTechScope(techScope, wizardKey);
        }
        return null;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        URLPath srcPath = null;
        try {
            URL[] entries;
            srcPath = this.fldSourcePath.getURLPath();
            if (srcPath == null || srcPath.size() <= 0) {
                this.fldSourcePath.requestFocus();
                throw new TraversalException(JProjectArb.getString((int)129), JProjectArb.getString((int)128));
            }
            for (URL url : entries = srcPath.getEntries()) {
                if (URLFileSystem.isValid((URL)url)) continue;
                this.fldSourcePath.requestFocus();
                String path = URLFileSystem.getPlatformPathName((URL)url);
                throw new TraversalException(JProjectArb.format((int)130, (Object)JProjectArb.getString((int)47), (Object)path), JProjectArb.getString((int)128));
            }
            dataContext.put("ProjectSourcePath", (Object)srcPath);
            this._prevTechScope = (TechnologyScope)dataContext.getDesignTimeObject("technologyScope");
        }
        catch (URLPathField.BadEntryException e) {
            this.fldSourcePath.requestFocus();
            throw new TraversalException(ControlsArb.format((int)55, (Object)e.getBadEntry()));
        }
        URL outDir = this.fldOutputDirectory.getURL();
        if (outDir == null || !URLFileSystem.isValid((URL)outDir)) {
            this.fldOutputDirectory.requestFocus();
            throw new TraversalException(JProjectArb.format((int)130, (Object)JProjectArb.getString((int)146), (Object)this.fldOutputDirectory.getText().trim()), JProjectArb.getString((int)145));
        }
        dataContext.put("OutputDirectory", (Object)outDir);
        String defPkg = this.fldDefaultPkg.getText().trim();
        if (ModelUtil.hasLength((String)defPkg)) {
            URL pkgDir;
            if (!IdeUtil.isPackageIdentifier((String)defPkg)) {
                this.fldDefaultPkg.requestFocus();
                throw new TraversalException(JProjectArb.format((int)127, (Object)defPkg));
            }
            if (srcPath != null && srcPath.size() > 0 && !URLFileSystem.canCreate((URL)(pkgDir = URLFactory.newDirURL((URL)srcPath.getEntries()[0], (String)defPkg)))) {
                this.fldDefaultPkg.requestFocus();
                throw new TraversalException(JProjectArb.getString((int)131), JProjectArb.getString((int)126));
            }
        }
        dataContext.put("DefaultPackage", (Object)defPkg);
    }

    public Component getDefaultFocusComponent() {
        return this.fldDefaultPkg;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.setDefaultTitle(WizardsArb.getString((int)8));
        this.pnlBottom.setLayout(this.layBottom);
        this.lblTop.setText(JProjectArb.getString((int)63));
        this.lblTop.setForeground(Colors.HINT_TEXT);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        ResourceUtils.resLabel((JLabel)this.lblDefaultPkg, (Component)this.fldDefaultPkg, (String)JProjectArb.getString((int)45));
        ResourceUtils.resLabel((JLabel)this.lblSourcePath, (Component)this.fldSourcePath, (String)JProjectArb.getString((int)46));
        this.fldSourcePath.setEditTitle(JProjectArb.getString((int)47));
        this.btnSourcePath.addActionListener((ActionListener)this.fldSourcePath);
        ResourceUtils.resButton((AbstractButton)this.btnSourcePath, (String)JProjectArb.getString((int)41));
        ResourceUtils.resLabel((JLabel)this.lblOutputDirectory, (Component)this.fldOutputDirectory, (String)JProjectArb.getString((int)142));
        this.btnOutputDirectory.addActionListener((ActionListener)this.fldOutputDirectory);
        ResourceUtils.resButton((AbstractButton)this.btnOutputDirectory, (String)JProjectArb.getString((int)60));
        this.add((Component)this.lblTop, "North");
        this.pnlBottom.add((Component)this.lblDefaultPkg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldDefaultPkg, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblSourcePath, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldSourcePath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnSourcePath, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblOutputDirectory, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldOutputDirectory, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnOutputDirectory, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pnlBottom.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.pnlBottom, "Center");
    }
}

