/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.ide.Context;
import oracle.ide.component.NewFilePanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.cmd.NewProjectContext;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.resource.WizardsArb;

public class NewProjectPanel
extends NewFilePanel {
    private Workspace _wksp;
    private static final String HELP_TOPIC = "f1_idednewproject_html";

    public NewProjectPanel() {
        this.setFileExtension(".jpr");
        this.setFileType(WizardsArb.getString((int)5));
        this.setFilePrompt(ComponentArb.getString((int)23));
        this.setShowExtension(false);
    }

    protected final DialogHeader createDialogHeader() {
        DialogHeader h = new DialogHeader();
        h.setHeaderDescription(WizardsArb.getString((int)519));
        h.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/project.png")));
        return h;
    }

    public static URL getProjectURL(Context ctx) {
        NewProjectPanel panel = new NewProjectPanel();
        panel.setContext(ctx);
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)panel), HELP_TOPIC);
        return panel.runDialog(WizardsArb.getString((int)0));
    }

    public URL getProjectURL(Runnable runnable) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), HELP_TOPIC);
        return this.runDialog(WizardsArb.getString((int)0), runnable);
    }

    public void setContext(Context ctx) {
        String name;
        DefaultNameGenerator nameGen;
        URL dirURL;
        Assert.check((ctx != null ? 1 : 0) != 0);
        this.setSupportsAutoFill(NewProjectContext.getSupportsAutoFill((Context)ctx, (boolean)this.isSupportsAutoFill()));
        this._wksp = ctx.getWorkspace();
        Assert.check((this._wksp != null ? 1 : 0) != 0);
        URL wkspURL = this._wksp.getURL();
        URL projDir = NewProjectContext.getProjectDirectory((Context)ctx, null);
        if (projDir == null && !URLFileSystem.isDirectoryPath((URL)(projDir = URLFactory.newUniqueURL((URL)(dirURL = URLFileSystem.getParent((URL)wkspURL)), (NameGenerator)(nameGen = new DefaultNameGenerator(Project.getDefaultName(), null, 1)))))) {
            projDir = URLFactory.newDirURL((URL)URLFileSystem.getParent((URL)projDir), (String)URLFileSystem.getFileName((URL)projDir));
        }
        if ((name = NewProjectContext.getProjectName((Context)ctx, null)) == null) {
            name = URLFileSystem.getFileName((URL)projDir);
        }
        if (NewProjectContext.getResetURLCache((Context)ctx, (boolean)false)) {
            this.resetURLCache();
        }
        this.setDirectoryURL(projDir);
        this.setFileName(name + ".jpr");
    }
}

