/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.iconoverlay;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.util.Assert;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.java.annotation.AnnotationSearcher;
import oracle.jdevimpl.java.annotation.HookJavaIconAnnotation;
import oracle.jdevimpl.java.iconoverlay.JavaIconOverlayHook;

public class JavaIconOverlayTracker
extends IconOverlayTracker {
    private static IconOverlay[] EMPTY_ICON_ARRAY = new IconOverlay[0];

    protected boolean isControlled(Element e) {
        return e instanceof JavaSourceNode;
    }

    protected IconOverlay[] getOverlays(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return EMPTY_ICON_ARRAY;
        }
        List<HookJavaIconAnnotation> javaAnnotations = JavaIconOverlayHook.getJavaAnnotations();
        if (javaAnnotations == null || javaAnnotations.isEmpty()) {
            return new IconOverlay[elements.length];
        }
        return JavaIconOverlayTracker.getOverlaysImpl(elements, javaAnnotations);
    }

    public static IconOverlay[] getOverlaysImpl(Element[] elements, List<HookJavaIconAnnotation> javaAnnotations) {
        IconOverlay[] iconOverlays = new IconOverlay[elements.length];
        try {
            List<AnnotationSearcher<HookJavaIconAnnotation>> searchers = AnnotationSearcher.makeSearchers(javaAnnotations);
            if (searchers.size() == 0) {
                return iconOverlays;
            }
            Map<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>> map = JavaIconOverlayTracker.groupElementsIntoContentSets(elements);
            return JavaIconOverlayTracker.processContentSets(map, searchers, iconOverlays);
        }
        catch (Exception ex) {
            FeedbackManager feedbackManager = FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((Throwable)ex);
            return iconOverlays;
        }
    }

    private static IconOverlay[] processContentSets(Map<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>> map, List<AnnotationSearcher<HookJavaIconAnnotation>> searchers, IconOverlay[] iconOverlays) {
        IndexManager im = IndexManager.getIndexManager();
        QueryCriteria criteria = new QueryCriteria();
        for (Map.Entry<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>> entry : map.entrySet()) {
            Project proj = (Project)entry.getKey().getFirst();
            Index index = im.getIndex(proj, (ContentSet)entry.getKey().getSecond());
            JavaIconOverlayTracker.runIndexQueries(index, searchers, criteria);
            JavaIconOverlayTracker.processNodes(proj, entry.getValue(), searchers, iconOverlays);
        }
        return iconOverlays;
    }

    private static void processNodes(Project project, Map<JavaSourceNode, Integer> nodes, List<AnnotationSearcher<HookJavaIconAnnotation>> potentialSearchers, IconOverlay[] iconOverlays) {
        ArrayList<AnnotationSearcher<HookJavaIconAnnotation>> searchers = new ArrayList<AnnotationSearcher<HookJavaIconAnnotation>>();
        for (AnnotationSearcher<HookJavaIconAnnotation> searcher : potentialSearchers) {
            HookJavaIconAnnotation annotation = searcher.getAnnotation();
            String rule = annotation.getRule();
            if (!JavaIconOverlayTracker.areRulesSatisfied(rule, project)) continue;
            searchers.add(searcher);
        }
        JavaManager javaManager = null;
        HashSet<String> processedIcons = new HashSet<String>();
        for (JavaSourceNode node : nodes.keySet()) {
            processedIcons.clear();
            String nodeUrl = node.getURL().toExternalForm();
            for (AnnotationSearcher annotationSearcher : searchers) {
                HookJavaIconAnnotation annotation;
                String iconName;
                if (!annotationSearcher.foundAnnotations(nodeUrl) || processedIcons.contains(iconName = (annotation = (HookJavaIconAnnotation)((Object)annotationSearcher.getAnnotation())).getIconName())) continue;
                if (javaManager == null && (javaManager = JavaManager.getInstance(project)) == null) {
                    return;
                }
                if (!annotationSearcher.confirmAnnotations(javaManager, node, true)) continue;
                Icon icon = annotation.getIcon();
                if (icon != null) {
                    iconOverlays[nodes.get((Object)((Object)node)).intValue()] = new IconOverlay(icon);
                }
                processedIcons.add(iconName);
            }
        }
    }

    private static boolean areRulesSatisfied(String rule, Project project) {
        if (rule == null || project == null) {
            return true;
        }
        RuleEngine engine = RuleEngine.getInstance();
        if (engine.isKnownRule(rule)) {
            Context context = new Context(null, project);
            return engine.evaluateRule(rule, context);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runIndexQueries(Index index, List<AnnotationSearcher<HookJavaIconAnnotation>> searchers, QueryCriteria criteria) {
        try {
            index.lock();
            try {
                for (AnnotationSearcher<HookJavaIconAnnotation> searcher : searchers) {
                    searcher.searchForAnnotations(criteria, index);
                }
            }
            finally {
                index.unlock();
            }
        }
        catch (InterruptedException e) {
            Assert.printStackTrace((Throwable)e);
        }
        catch (LockFailedException e) {
            Assert.printStackTrace((Throwable)e);
        }
        finally {
            index.release();
        }
    }

    private static Map<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>> groupElementsIntoContentSets(Element[] elements) {
        HashMap<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>> map = new HashMap<Pair<Project, ContentSet>, Map<JavaSourceNode, Integer>>();
        ContentSet currentContentSet = null;
        Map<JavaSourceNode, Integer> currentNodeMap = null;
        block0: for (int elementIndex = 0; elementIndex < elements.length; ++elementIndex) {
            JavaSourceNode jsn = (JavaSourceNode)elements[elementIndex];
            URL url = jsn.getURL();
            if (currentContentSet != null && currentContentSet.canHaveMember(url)) {
                currentNodeMap.put(jsn, elementIndex);
                continue;
            }
            Collection collection = ContentSetRoot.getContentSetRootsContaining((URL)url);
            for (ContentSetRoot csr : collection) {
                if (csr.getProject() == null) continue;
                Project project = csr.getProject();
                ContentSet content = PathsConfiguration.getInstance((Project)project).getJavaContentSet();
                Pair pair = new Pair((Object)project, (Object)content);
                currentContentSet = content;
                if (!map.containsKey(pair)) {
                    currentNodeMap = new HashMap<JavaSourceNode, Integer>();
                    map.put((Pair<Project, ContentSet>)pair, currentNodeMap);
                } else {
                    currentNodeMap = (Map)map.get(pair);
                }
                currentNodeMap.put(jsn, elementIndex);
                continue block0;
            }
        }
        return map;
    }
}

