/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaProjectIndexer;

public final class JavaParserPlugin
implements ActionListener,
EditorPlugin,
FocusListener,
Observer {
    private JavaSourceNode javaNode;
    private Project project;
    private RestartListener restartListener = new RestartListener();
    private static final Log LOG;
    private static final boolean DEBUG_VERBOSE = false;
    private static final int SMALL_FILE_SIZE = 20000;
    private static final int LARGE_FILE_SIZE = 100000;
    private static final int SMALL_FILE_DELAY;
    private static final int LARGE_FILE_DELAY;
    private CopyOnWriteList helperList = new CopyOnWriteList();
    private static final String PLUGIN_KEY;
    private static final int LONG_TIMER_DELAY = 2000;
    private volatile int _lastDelayUsed = SMALL_FILE_DELAY;
    private BasicEditorPane editor;
    private Timer updateTimer;
    private SemanticTask smTask = null;
    private JavaManager smJavaManager = null;
    private SourceFile smTaskSourceFile = null;
    private int smTaskChangeId = -1;
    private static AsyncScheduler smScheduler;

    private static final void verbosePrintln(String message) {
        assert (LOG.trace(message));
    }

    private static final void verbosePrintTiming(long time, String message, String indent) {
        assert (LOG.trace("[{0}ms]{1}", time, (Object)message));
    }

    private static int getCompileDelay(int fileSize) {
        if (fileSize <= 20000) {
            return SMALL_FILE_DELAY;
        }
        if (fileSize >= 100000) {
            return LARGE_FILE_DELAY;
        }
        int delayToUse = (LARGE_FILE_DELAY - SMALL_FILE_DELAY) * (fileSize - 20000) / 80000;
        return delayToUse += SMALL_FILE_DELAY;
    }

    private void notifyCompileScheduled() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: notify scheduled");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyCompileScheduled();
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    private void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int parseTime) {
        int elapsedDelay = this._lastDelayUsed + parseTime;
        JavaParserPlugin.verbosePrintTiming(parseTime, "CompilerHelper: notify parse finished, changeId: " + changeId, "");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyParseFinished(javaManager, sourceFile, changeId, elapsedDelay);
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    private void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int compileTime) {
        int elapsedDelay = this._lastDelayUsed + compileTime;
        JavaParserPlugin.verbosePrintTiming(compileTime, "CompilerHelper: notify finished, changeId: " + changeId, "");
        for (HelperClient client : this.helperList) {
            try {
                client.notifyCompileFinished(javaManager, sourceFile, changeId, elapsedDelay);
            }
            catch (RuntimeException e) {
                Assert.println((String)("HelperClient notify exception occurred: " + e.toString()));
                Assert.printStackTrace((Throwable)e);
                FeedbackManager.reportException((String)"HelperClient notify exception occurred: ", (Throwable)e);
            }
        }
    }

    public static void attachHelperClient(BasicEditorPane editor, HelperClient client) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: attaching helper client");
        JavaParserPlugin plugin = JavaParserPlugin.lookupOrCreatePlugin(editor);
        plugin.helperList.addIfAbsent((Object)client);
    }

    public static void detachHelperClient(BasicEditorPane editor, HelperClient client) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching helper client");
        JavaParserPlugin plugin = JavaParserPlugin.lookupPlugin(editor);
        if (plugin != null) {
            plugin.helperList.remove((Object)client);
        }
    }

    public static void ensureCompileScheduled(BasicEditorPane editor) {
        JavaParserPlugin plugin = (JavaParserPlugin)editor.getProperty(PLUGIN_KEY);
        if (plugin != null) {
            plugin.ensureCompileScheduled();
        }
    }

    private void detachAllClients() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching all client");
        this.helperList.clear();
    }

    private static synchronized JavaParserPlugin lookupPlugin(BasicEditorPane editor) {
        return (JavaParserPlugin)editor.getProperty(PLUGIN_KEY);
    }

    private static synchronized JavaParserPlugin lookupOrCreatePlugin(BasicEditorPane editor) {
        JavaParserPlugin plugin = JavaParserPlugin.lookupPlugin(editor);
        if (plugin == null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: installing new helper");
            plugin = new JavaParserPlugin();
            editor.installPlugin((EditorPlugin)plugin);
        }
        return plugin;
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addFocusListener((FocusListener)this);
        BasicDocument document = this.getDocument();
        document.addPropertyChangeListener((PropertyChangeListener)this.restartListener);
        document.addDocumentListener((DocumentListener)this.restartListener);
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        this.restartTimer();
        editor.putProperty(PLUGIN_KEY, (Object)this);
        Context context = CodeEditor.getContext((BasicEditorPane)editor);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
    }

    private void updateContext(Context newContext) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
        }
        this.javaNode = null;
        if (newContext != null) {
            this.javaNode = (JavaSourceNode)newContext.getNode();
            this.project = newContext.getProject();
            LOG.trace("updating context of {0} to {1}", (Object)this, (Object)newContext);
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane editor) {
        editor.putProperty(PLUGIN_KEY, null);
        this.cancelSemantic();
        this.updateContext(null);
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
        this.detachAllClients();
        BasicDocument document = this.getDocument();
        if (document != null) {
            document.removeDocumentListener((DocumentListener)this.restartListener);
            document.removePropertyChangeListener((PropertyChangeListener)this.restartListener);
        }
        editor.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    @Override
    public void focusGained(FocusEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus gained, restarting");
        this.restartTimer();
    }

    @Override
    public void focusLost(FocusEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus lost");
        this.stopTimer();
    }

    public void update(Object observed, UpdateMessage change) {
        if (observed instanceof Project) {
            int messageId = change.getMessageID();
            if (messageId == UpdateMessage.OBJECT_RELOADED || messageId == UpdateMessage.PROPERTY_SET) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: property updated");
                this.restartTimer(true);
            } else if (messageId == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("editor-ide-context")) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: editor context changed");
            this.cancelSemantic();
            Context newContext = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(newContext);
            this.restartTimer(true);
        } else if ("ancestor".equals(propertyName)) {
            if (event.getNewValue() != null) {
                this.ensureCompileScheduled();
            } else {
                this.cancelSemantic();
            }
        }
    }

    private void restartTimer() {
        this.restartTimer(false);
    }

    private void restartTimer(boolean forceLong) {
        try {
            if (this.editor == null || !this.editor.isShowing()) {
                return;
            }
            int fileSize = this.getDocument().getLength();
            int compileDelay = JavaParserPlugin.getCompileDelay(fileSize);
            if (forceLong) {
                compileDelay = Math.max(compileDelay, 2000);
            }
            this._lastDelayUsed = compileDelay;
            this.restartTimer(compileDelay);
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void restartTimer(int delayToUse) {
        this.notifyCompileScheduled();
        this.cancelSemantic();
        this.updateTimer.setInitialDelay(delayToUse);
        this.updateTimer.restart();
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer restarted: " + delayToUse);
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompileScheduled() {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.updateTimer != null && !this.updateTimer.isRunning() && this.smTask == null) {
                this.restartTimer();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer triggered");
        this.scheduleSemantic();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSemantic() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: scheduling new task");
        SemanticTask task = new SemanticTask();
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask != null) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: cancelled in progress");
                smScheduler.cancelTask((AsyncTask)this.smTask);
            }
            this.smTask = task;
        }
        smScheduler.scheduleTask((AsyncTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSemantic() {
        SemanticTask pendingTask;
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            pendingTask = this.smTask;
            this.smTask = null;
        }
        if (pendingTask != null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: cancelling task");
            smScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSemantic(SemanticTask task) {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask == task) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: finishing task");
                this.smTask = null;
            }
        }
    }

    static {
        int large;
        int small;
        LOG = new Log(new String[]{"parser", "editor"});
        int SMALL_MIN = 100;
        int SMALL_DEFAULT = 300;
        int SMALL_MAX = 50000;
        String smallProperty = System.getProperty("ceditor.java.parse.small");
        try {
            small = Integer.parseInt(smallProperty);
            small = Math.min(small, 50000);
            small = Math.max(small, 100);
        }
        catch (NumberFormatException e) {
            small = 300;
        }
        SMALL_FILE_DELAY = small;
        int LARGE_MIN = 500;
        int LARGE_DEFAULT = 1500;
        int LARGE_MAX = 50000;
        String largeProperty = System.getProperty("ceditor.java.parse.large");
        try {
            large = Integer.parseInt(largeProperty);
            large = Math.min(large, 50000);
            large = Math.max(large, 500);
        }
        catch (NumberFormatException e) {
            large = 1500;
        }
        LARGE_FILE_DELAY = large;
        PLUGIN_KEY = JavaParserPlugin.class.getName();
        smScheduler = new AsyncScheduler("SemanticChecker", 30000);
    }

    private final class RestartListener
    implements DocumentListener,
    PropertyChangeListener {
        private boolean compoundEditInProgress;

        private RestartListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("compoundEditInProgress".equals(e.getPropertyName())) {
                this.compoundEditInProgress = (Boolean)e.getNewValue();
                if (this.compoundEditInProgress) {
                    JavaParserPlugin.this.stopTimer();
                    JavaParserPlugin.this.cancelSemantic();
                } else {
                    JavaParserPlugin.this.restartTimer();
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
            if (!this.compoundEditInProgress) {
                JavaParserPlugin.this.restartTimer();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
            if (!this.compoundEditInProgress) {
                JavaParserPlugin.this.restartTimer();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
            if (!this.compoundEditInProgress) {
                JavaParserPlugin.this.restartTimer();
            }
        }
    }

    private final class SemanticTask
    extends AsyncTask {
        private Project smProject;
        private JavaSourceNode smNode;
        private boolean smCancelled;
        private volatile boolean waitingOnIndex;
        private Object waitingLock = new Object();

        private SemanticTask() {
            this.smProject = JavaParserPlugin.this.project;
            this.smNode = JavaParserPlugin.this.javaNode;
            this.smCancelled = false;
        }

        protected void requestCancelImpl() {
            JavaParserPlugin.verbosePrintln("requesting cancel");
            this.smCancelled = true;
            SourceFile file = JavaParserPlugin.this.smTaskSourceFile;
            if (file != null) {
                file.cancelCompile();
            }
        }

        protected boolean isCancelledImpl() {
            return this.smCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() throws AsyncTask.CancelledException {
            final long compileStart = System.currentTimeMillis();
            try {
                int changeId;
                TextBuffer textBuffer;
                JavaParserPlugin.verbosePrintln("CompilerHelper: task entry");
                if (!this.smNode.isOpen()) {
                    Object var3_2 = null;
                    return var3_2;
                }
                if (JavaParserPlugin.this.smJavaManager == null) {
                    JavaParserPlugin.this.smJavaManager = JavaManager.getAnyJavaManager(this.smProject);
                }
                if ((textBuffer = this.smNode.acquireTextBuffer()) == null) {
                    Object var4_4 = null;
                    return var4_4;
                }
                this.bailIfCancelled();
                JavaParserPlugin.verbosePrintln("CompilerHelper: parse start");
                SourceFile sourceFile = null;
                textBuffer.readLock();
                try {
                    changeId = textBuffer.getChangeId();
                    textBuffer.readLock();
                    try {
                        sourceFile = JavaParserPlugin.this.smJavaManager.getSourceFile(textBuffer);
                        if (sourceFile == null) {
                            Object var6_7 = null;
                            return var6_7;
                        }
                        sourceFile.setURL(JavaParserPlugin.this.javaNode.getURL());
                    }
                    finally {
                        textBuffer.readUnlock();
                    }
                    LOG.trace("new source file {2} id {0}; old source file {3} id {1}", changeId, JavaParserPlugin.this.smTaskChangeId, (Object)sourceFile, (Object)JavaParserPlugin.this.smTaskSourceFile);
                    JavaParserPlugin.this.smTaskChangeId = changeId;
                    JavaParserPlugin.this.smTaskSourceFile = sourceFile;
                }
                finally {
                    textBuffer.readUnlock();
                }
                this.bailIfCancelled();
                final int passChangeId = changeId;
                final SourceFile passSourceFile = sourceFile;
                Runnable notifier = new Runnable(){

                    @Override
                    public void run() {
                        long compileTotal = System.currentTimeMillis() - compileStart;
                        if (!SemanticTask.this.isCancelledImpl()) {
                            JavaParserPlugin.verbosePrintln("CompilerHelper: performing notify");
                            JavaParserPlugin.this.notifyParseFinished(JavaParserPlugin.this.smJavaManager, passSourceFile, passChangeId, (int)compileTotal);
                        }
                    }
                };
                SwingUtilities.invokeLater(notifier);
                JavaParserPlugin.verbosePrintln("CompilerHelper: semantic compile start");
                CacheSupport cacheSupport = JavaParserPlugin.this.smJavaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    LOG.trace("compiling, isCompiled {0}", sourceFile.isCompiled());
                    sourceFile.compile();
                    this.bailIfCancelled();
                }
                catch (CancellationException e) {
                    JavaParserPlugin.verbosePrintln("cancelled during semantic");
                    throw e;
                }
                catch (AsyncTask.CancelledException e) {
                    JavaParserPlugin.verbosePrintln("cancelled during semantic");
                    throw e;
                }
                catch (ExpiredTextBufferException e) {
                    JavaParserPlugin.verbosePrintln("expired during semantic");
                    throw e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    JavaParserPlugin.verbosePrintln("exception during semantic: " + e);
                    throw new UnexpectedExceptionError(e);
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                final JavaProjectIndexer indexer = JavaProjectIndexer.getJavaProjectIndexer();
                if (this.smProject.isOpen() && !indexer.isIndexed(this.smProject)) {
                    Object object = this.waitingLock;
                    synchronized (object) {
                        if (!this.waitingOnIndex) {
                            this.waitingOnIndex = true;
                            JavaParserPlugin.verbosePrintln("CompilerHelper: begin wait for index");
                            final Project project = this.smProject;
                            Thread thread = new Thread("ProjectIndexWait-" + this.smProject.getShortLabel()){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    indexer.waitUntilIndexed(project);
                                    Object object = SemanticTask.this.waitingLock;
                                    synchronized (object) {
                                        SemanticTask.this.waitingOnIndex = false;
                                    }
                                    JavaParserPlugin.verbosePrintln("CompilerHelper: indexing completed");
                                    JavaParserPlugin.this.ensureCompileScheduled();
                                }
                            };
                            thread.start();
                        }
                    }
                }
                JavaParserPlugin.verbosePrintln("CompilerHelper: scheduling notify");
                Runnable compileNotifier = new Runnable(){

                    @Override
                    public void run() {
                        long compileTotal = System.currentTimeMillis() - compileStart;
                        if (!SemanticTask.this.isCancelledImpl()) {
                            JavaParserPlugin.verbosePrintln("CompilerHelper: performing notify");
                            JavaParserPlugin.this.notifyCompileFinished(JavaParserPlugin.this.smJavaManager, passSourceFile, passChangeId, (int)compileTotal);
                        }
                    }
                };
                SwingUtilities.invokeLater(compileNotifier);
                Object var12_21 = null;
                return var12_21;
            }
            finally {
                JavaParserPlugin.this.finishSemantic(this);
            }
        }
    }

    public static interface HelperClient {
        public void notifyCompileScheduled();

        public void notifyParseFinished(JavaManager var1, SourceFile var2, int var3, int var4);

        public void notifyCompileFinished(JavaManager var1, SourceFile var2, int var3, int var4);
    }
}

